/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.redis.lock;

import io.seata.common.exception.StoreException;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.LambdaUtils;
import io.seata.core.exception.BranchTransactionException;
import io.seata.core.exception.TransactionExceptionCode;
import io.seata.core.lock.RowLock;
import io.seata.core.model.LockStatus;
import io.seata.core.store.LockDO;
import io.seata.server.storage.redis.JedisPooledFactory;
import io.seata.server.storage.redis.LuaParser;
import io.seata.server.storage.redis.lock.RedisLocker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class RedisLuaLocker
extends RedisLocker {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisLuaLocker.class);
    private static final String LUA_PREFIX = "lua/redislocker/";
    private static final String ACQUIRE_LOCK_LUA_FILE_NAME = "lua/redislocker/acquireRedisLock.lua";
    private static final String RELEASE_LOCK_LUA_FILE_NAME = "lua/redislocker/releaseRedisLock.lua";
    private static final String UPDATE_LOCK_LUA_FILE_NAME = "lua/redislocker/updateLockStatus.lua";
    private static final String LOCKABLE_LUA_FILE_NAME = "lua/redislocker/isLockable.lua";
    private static final Map<String, String> LOCK_SHA_MAP = new HashMap<String, String>(4);

    public RedisLuaLocker() {
        if (LOCK_SHA_MAP.isEmpty()) {
            this.loadLuaFile(ACQUIRE_LOCK_LUA_FILE_NAME, "acquire lock");
            this.loadLuaFile(RELEASE_LOCK_LUA_FILE_NAME, "release lock");
            this.loadLuaFile(UPDATE_LOCK_LUA_FILE_NAME, "update lock");
            this.loadLuaFile(LOCKABLE_LUA_FILE_NAME, "lockable");
        }
    }

    private void loadLuaFile(String fileName, String mode) {
        block3: {
            try {
                LOCK_SHA_MAP.putAll(LuaParser.getEvalShaMapFromFile(fileName));
            }
            catch (IOException e) {
                if (LOCK_SHA_MAP.get(fileName) != null) {
                    LOCK_SHA_MAP.remove(fileName);
                }
                if (!LOGGER.isInfoEnabled()) break block3;
                LOGGER.info("redis locker: {} use pipeline mode", (Object)mode);
            }
        }
    }

    @Override
    public boolean acquireLock(List<RowLock> rowLocks, boolean autoCommit, boolean skipCheckLock) {
        if (CollectionUtils.isEmpty(rowLocks)) {
            return true;
        }
        String luaSHA = LOCK_SHA_MAP.get(ACQUIRE_LOCK_LUA_FILE_NAME);
        if (luaSHA == null) {
            return super.acquireLock(rowLocks, autoCommit, skipCheckLock);
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            String needLockXid = rowLocks.get(0).getXid();
            Long branchId = rowLocks.get(0).getBranchId();
            List needLockDOs = rowLocks.stream().map(arg_0 -> ((RedisLuaLocker)this).convertToLockDO(arg_0)).filter(LambdaUtils.distinctByKey(LockDO::getRowKey)).collect(Collectors.toList());
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<String> args = new ArrayList<String>();
            int size = needLockDOs.size();
            args.add(String.valueOf(size));
            args.add(null);
            args.add(needLockXid);
            for (LockDO lockDO2 : needLockDOs) {
                keys.add(this.buildLockKey(lockDO2.getRowKey()));
                args.add(lockDO2.getTransactionId().toString());
                args.add(lockDO2.getBranchId().toString());
                args.add(lockDO2.getResourceId());
                args.add(lockDO2.getTableName());
                args.add(lockDO2.getRowKey());
                args.add(lockDO2.getPk());
            }
            String xidLockKey = this.buildXidLockKey(needLockXid);
            StringJoiner lockKeysString = new StringJoiner(";");
            needLockDOs.stream().map(lockDO -> this.buildLockKey(lockDO.getRowKey())).forEach(lockKeysString::add);
            keys.add(xidLockKey);
            keys.add(branchId.toString());
            args.add(lockKeysString.toString());
            args.set(1, String.valueOf(args.size()));
            String result = (String)LuaParser.jedisEvalSha(jedis, luaSHA, ACQUIRE_LOCK_LUA_FILE_NAME, keys, args);
            LuaParser.LuaResult luaResult = LuaParser.getObjectFromJson(result, LuaParser.LuaResult.class);
            if (luaResult.getSuccess().booleanValue() && luaResult.getData().equals(needLockXid)) {
                boolean bl = true;
                return bl;
            }
            if ("AnotherRollbackIng".equals(luaResult.getStatus())) {
                throw new StoreException((Throwable)new BranchTransactionException(TransactionExceptionCode.LockKeyConflictFailFast));
            }
            if ("AnotherHoldIng".equals(luaResult.getStatus())) {
                this.logGlobalLockConflictInfo(needLockXid, (String)keys.get(0), luaResult.getData());
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public boolean releaseLock(String xid) {
        String luaSHA = LOCK_SHA_MAP.get(RELEASE_LOCK_LUA_FILE_NAME);
        if (luaSHA == null) {
            return super.releaseLock(xid);
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            String xidLockKey = this.buildXidLockKey(xid);
            ArrayList<String> keys = new ArrayList<String>();
            List<String> args = Collections.emptyList();
            keys.add(xidLockKey);
            LuaParser.jedisEvalSha(jedis, luaSHA, RELEASE_LOCK_LUA_FILE_NAME, keys, args);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean releaseLock(String xid, Long branchId) {
        if (branchId == null) {
            return true;
        }
        String luaSHA = LOCK_SHA_MAP.get(RELEASE_LOCK_LUA_FILE_NAME);
        if (luaSHA == null) {
            return super.releaseLock(xid, branchId);
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            String xidLockKey = this.buildXidLockKey(xid);
            ArrayList<String> keys = new ArrayList<String>();
            List<String> args = Collections.emptyList();
            keys.add(xidLockKey);
            keys.add(String.valueOf(branchId));
            LuaParser.jedisEvalSha(jedis, luaSHA, RELEASE_LOCK_LUA_FILE_NAME, keys, args);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean isLockable(List<RowLock> rowLocks) {
        if (CollectionUtils.isEmpty(rowLocks)) {
            return true;
        }
        String luaSHA = LOCK_SHA_MAP.get(LOCKABLE_LUA_FILE_NAME);
        if (luaSHA == null) {
            return super.isLockable(rowLocks);
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            List locks = this.convertToLockDO(rowLocks);
            HashSet<String> lockKeys = new HashSet<String>();
            for (LockDO rowlock : locks) {
                lockKeys.add(this.buildLockKey(rowlock.getRowKey()));
            }
            String xid = rowLocks.get(0).getXid();
            ArrayList<String> keys = new ArrayList<String>();
            keys.add(String.valueOf(lockKeys.size()));
            keys.addAll(lockKeys);
            ArrayList<String> args = new ArrayList<String>();
            args.add(xid);
            String res = (String)LuaParser.jedisEvalSha(jedis, luaSHA, LOCKABLE_LUA_FILE_NAME, keys, args);
            boolean bl = "true".equals(res);
            return bl;
        }
    }

    @Override
    public void updateLockStatus(String xid, LockStatus lockStatus) {
        String luaSHA = LOCK_SHA_MAP.get(UPDATE_LOCK_LUA_FILE_NAME);
        if (luaSHA == null) {
            super.updateLockStatus(xid, lockStatus);
            return;
        }
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            String xidLockKey = this.buildXidLockKey(xid);
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<String> args = new ArrayList<String>();
            keys.add(xidLockKey);
            keys.add("status");
            args.add(String.valueOf(lockStatus.getCode()));
            LuaParser.jedisEvalSha(jedis, luaSHA, UPDATE_LOCK_LUA_FILE_NAME, keys, args);
        }
    }
}

