/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.redis.lock;

import io.seata.common.executor.Initialize;
import io.seata.common.loader.LoadLevel;
import io.seata.core.exception.TransactionException;
import io.seata.core.lock.Locker;
import io.seata.server.lock.AbstractLockManager;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.storage.redis.lock.RedisLockerFactory;

@LoadLevel(name="redis")
public class RedisLockManager
extends AbstractLockManager
implements Initialize {
    private Locker locker;

    public void init() {
        this.locker = RedisLockerFactory.getLocker();
    }

    @Override
    public Locker getLocker(BranchSession branchSession) {
        return this.locker;
    }

    @Override
    public boolean releaseLock(BranchSession branchSession) throws TransactionException {
        try {
            return this.getLocker().releaseLock(branchSession.getXid(), Long.valueOf(branchSession.getBranchId()));
        }
        catch (Exception t) {
            LOGGER.error("unLock error, xid {}, branchId:{}", new Object[]{branchSession.getXid(), branchSession.getBranchId(), t});
            return false;
        }
    }

    @Override
    public boolean releaseGlobalSessionLock(GlobalSession globalSession) throws TransactionException {
        try {
            return this.getLocker().releaseLock(globalSession.getXid());
        }
        catch (Exception t) {
            LOGGER.error("unLock globalSession error, xid:{}", (Object)globalSession.getXid(), (Object)t);
            return false;
        }
    }
}

