/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.session;

import io.seata.common.util.CompressUtil;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.BranchStatus;
import io.seata.core.model.BranchType;
import io.seata.core.model.LockStatus;
import io.seata.server.lock.LockManager;
import io.seata.server.lock.LockerManagerFactory;
import io.seata.server.session.Lockable;
import io.seata.server.storage.file.lock.FileLocker;
import io.seata.server.store.SessionStorable;
import io.seata.server.store.StoreConfig;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchSession
implements Lockable,
Comparable<BranchSession>,
SessionStorable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BranchSession.class);
    private static final int MAX_BRANCH_SESSION_SIZE = StoreConfig.getMaxBranchSessionSize();
    private static ThreadLocal<ByteBuffer> byteBufferThreadLocal = ThreadLocal.withInitial(() -> ByteBuffer.allocate(MAX_BRANCH_SESSION_SIZE));
    private String xid;
    private long transactionId;
    private long branchId;
    private String resourceGroupId;
    private String resourceId;
    private String lockKey;
    private BranchType branchType;
    private BranchStatus status = BranchStatus.Unknown;
    private String clientId;
    private String applicationData;
    private LockStatus lockStatus = LockStatus.Locked;
    private final Map<FileLocker.BucketLockMap, Set<String>> lockHolder;
    private final LockManager lockManager = LockerManagerFactory.getLockManager();

    public BranchSession() {
        this.lockHolder = new ConcurrentHashMap<FileLocker.BucketLockMap, Set<String>>(2);
    }

    public BranchSession(BranchType branchType) {
        this.branchType = branchType;
        this.lockHolder = branchType == BranchType.AT ? new ConcurrentHashMap(8) : Collections.emptyMap();
    }

    public String getApplicationData() {
        return this.applicationData;
    }

    public void setApplicationData(String applicationData) {
        this.applicationData = applicationData;
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public void setResourceGroupId(String resourceGroupId) {
        this.resourceGroupId = resourceGroupId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getLockKey() {
        return this.lockKey;
    }

    public void setLockKey(String lockKey) {
        this.lockKey = lockKey;
    }

    public BranchType getBranchType() {
        return this.branchType;
    }

    public void setBranchType(BranchType branchType) {
        this.branchType = branchType;
    }

    public BranchStatus getStatus() {
        return this.status;
    }

    public void setStatus(BranchStatus status) {
        this.status = status;
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(long transactionId) {
        this.transactionId = transactionId;
    }

    public long getBranchId() {
        return this.branchId;
    }

    public void setBranchId(long branchId) {
        this.branchId = branchId;
    }

    public String getXid() {
        return this.xid;
    }

    public void setXid(String xid) {
        this.xid = xid;
    }

    public String toString() {
        return "BR:" + this.branchId + "/" + this.transactionId;
    }

    @Override
    public int compareTo(BranchSession o) {
        return Long.compare(this.branchId, o.branchId);
    }

    public boolean canBeCommittedAsync() {
        return this.branchType == BranchType.AT || this.status == BranchStatus.PhaseOne_Failed;
    }

    public Map<FileLocker.BucketLockMap, Set<String>> getLockHolder() {
        return this.lockHolder;
    }

    @Override
    public boolean lock() throws TransactionException {
        return this.lock(true, false);
    }

    public boolean lock(boolean autoCommit, boolean skipCheckLock) throws TransactionException {
        if (this.branchType.equals((Object)BranchType.AT)) {
            return this.lockManager.acquireLock(this, autoCommit, skipCheckLock);
        }
        return true;
    }

    @Override
    public boolean unlock() throws TransactionException {
        if (this.branchType == BranchType.AT) {
            return this.lockManager.releaseLock(this);
        }
        return true;
    }

    public boolean isAT() {
        return this.getBranchType() == BranchType.AT;
    }

    public LockStatus getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(LockStatus lockStatus) {
        this.lockStatus = lockStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encode() {
        byte[] resourceIdBytes = this.resourceId != null ? this.resourceId.getBytes() : null;
        byte[] lockKeyBytes = this.lockKey != null ? this.lockKey.getBytes() : null;
        byte[] clientIdBytes = this.clientId != null ? this.clientId.getBytes() : null;
        byte[] applicationDataBytes = this.applicationData != null ? this.applicationData.getBytes() : null;
        byte[] xidBytes = this.xid != null ? this.xid.getBytes() : null;
        byte branchTypeByte = this.branchType != null ? (byte)this.branchType.ordinal() : (byte)-1;
        int size = this.calBranchSessionSize(resourceIdBytes, lockKeyBytes, clientIdBytes, applicationDataBytes, xidBytes);
        if (size > MAX_BRANCH_SESSION_SIZE) {
            if (lockKeyBytes == null) {
                throw new RuntimeException("branch session size exceeded, size : " + size + " maxBranchSessionSize : " + MAX_BRANCH_SESSION_SIZE);
            }
            try {
                size -= lockKeyBytes.length;
                lockKeyBytes = CompressUtil.compress((byte[])lockKeyBytes);
            }
            catch (IOException e) {
                LOGGER.error("compress lockKey error", (Throwable)e);
            }
            finally {
                size += lockKeyBytes.length;
            }
            if (size > MAX_BRANCH_SESSION_SIZE) {
                throw new RuntimeException("compress branch session size exceeded, compressSize : " + size + " maxBranchSessionSize : " + MAX_BRANCH_SESSION_SIZE);
            }
        }
        ByteBuffer byteBuffer = byteBufferThreadLocal.get();
        byteBuffer.clear();
        byteBuffer.putLong(this.transactionId);
        byteBuffer.putLong(this.branchId);
        if (resourceIdBytes != null) {
            byteBuffer.putInt(resourceIdBytes.length);
            byteBuffer.put(resourceIdBytes);
        } else {
            byteBuffer.putInt(0);
        }
        if (lockKeyBytes != null) {
            byteBuffer.putInt(lockKeyBytes.length);
            byteBuffer.put(lockKeyBytes);
        } else {
            byteBuffer.putInt(0);
        }
        if (clientIdBytes != null) {
            byteBuffer.putShort((short)clientIdBytes.length);
            byteBuffer.put(clientIdBytes);
        } else {
            byteBuffer.putShort((short)0);
        }
        if (applicationDataBytes != null) {
            byteBuffer.putInt(applicationDataBytes.length);
            byteBuffer.put(applicationDataBytes);
        } else {
            byteBuffer.putInt(0);
        }
        if (xidBytes != null) {
            byteBuffer.putInt(xidBytes.length);
            byteBuffer.put(xidBytes);
        } else {
            byteBuffer.putInt(0);
        }
        byteBuffer.put(branchTypeByte);
        byteBuffer.put((byte)this.status.getCode());
        byteBuffer.put((byte)this.lockStatus.getCode());
        byteBuffer.flip();
        byte[] result = new byte[byteBuffer.limit()];
        byteBuffer.get(result);
        return result;
    }

    private int calBranchSessionSize(byte[] resourceIdBytes, byte[] lockKeyBytes, byte[] clientIdBytes, byte[] applicationDataBytes, byte[] xidBytes) {
        int size = 35 + (resourceIdBytes == null ? 0 : resourceIdBytes.length) + (lockKeyBytes == null ? 0 : lockKeyBytes.length) + (clientIdBytes == null ? 0 : clientIdBytes.length) + (applicationDataBytes == null ? 0 : applicationDataBytes.length) + (xidBytes == null ? 0 : xidBytes.length) + 1;
        return size;
    }

    @Override
    public void decode(byte[] a) {
        byte branchTypeId;
        int xidLen;
        int applicationDataLen;
        short clientIdLen;
        int lockKeyLen;
        ByteBuffer byteBuffer = ByteBuffer.wrap(a);
        this.transactionId = byteBuffer.getLong();
        this.branchId = byteBuffer.getLong();
        int resourceLen = byteBuffer.getInt();
        if (resourceLen > 0) {
            byte[] byResource = new byte[resourceLen];
            byteBuffer.get(byResource);
            this.resourceId = new String(byResource);
        }
        if ((lockKeyLen = byteBuffer.getInt()) > 0) {
            byte[] byLockKey = new byte[lockKeyLen];
            byteBuffer.get(byLockKey);
            if (CompressUtil.isCompressData((byte[])byLockKey)) {
                try {
                    this.lockKey = new String(CompressUtil.uncompress((byte[])byLockKey));
                }
                catch (IOException e) {
                    throw new RuntimeException("decompress lockKey error", e);
                }
            } else {
                this.lockKey = new String(byLockKey);
            }
        }
        if ((clientIdLen = byteBuffer.getShort()) > 0) {
            byte[] byClientId = new byte[clientIdLen];
            byteBuffer.get(byClientId);
            this.clientId = new String(byClientId);
        }
        if ((applicationDataLen = byteBuffer.getInt()) > 0) {
            byte[] byApplicationData = new byte[applicationDataLen];
            byteBuffer.get(byApplicationData);
            this.applicationData = new String(byApplicationData);
        }
        if ((xidLen = byteBuffer.getInt()) > 0) {
            byte[] xidBytes = new byte[xidLen];
            byteBuffer.get(xidBytes);
            this.xid = new String(xidBytes);
        }
        if ((branchTypeId = byteBuffer.get()) >= 0) {
            this.branchType = BranchType.values()[branchTypeId];
        }
        this.status = BranchStatus.get((byte)byteBuffer.get());
    }
}

