/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.coordinator;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.CollectionUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.core.exception.TransactionException;
import io.seata.core.logger.StackTraceLogger;
import io.seata.core.model.BranchStatus;
import io.seata.core.model.BranchType;
import io.seata.core.model.GlobalStatus;
import io.seata.core.rpc.RemotingServer;
import io.seata.server.coordinator.AbstractCore;
import io.seata.server.coordinator.Core;
import io.seata.server.metrics.MetricsPublisher;
import io.seata.server.session.BranchSession;
import io.seata.server.session.BranchSessionHandler;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionHelper;
import io.seata.server.session.SessionHolder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class DefaultCore
implements Core {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCore.class);
    private static final int RETRY_XAER_NOTA_TIMEOUT = ConfigurationFactory.getInstance().getInt("server.xaerNotaRetryTimeout", 60000);
    private static Map<BranchType, AbstractCore> coreMap = new ConcurrentHashMap<BranchType, AbstractCore>();
    private static final boolean PARALLEL_HANDLE_BRANCH = ConfigurationFactory.getInstance().getBoolean("server.enableParallelHandleBranch", false);

    public DefaultCore(RemotingServer remotingServer) {
        List allCore = EnhancedServiceLoader.loadAll(AbstractCore.class, (Class[])new Class[]{RemotingServer.class}, (Object[])new Object[]{remotingServer});
        if (CollectionUtils.isNotEmpty((Collection)allCore)) {
            for (AbstractCore core : allCore) {
                coreMap.put(core.getHandleBranchType(), core);
            }
        }
    }

    public AbstractCore getCore(BranchType branchType) {
        AbstractCore core = coreMap.get(branchType);
        if (core == null) {
            throw new NotSupportYetException("unsupported type:" + branchType.name());
        }
        return core;
    }

    public void mockCore(BranchType branchType, AbstractCore core) {
        coreMap.put(branchType, core);
    }

    public Long branchRegister(BranchType branchType, String resourceId, String clientId, String xid, String applicationData, String lockKeys) throws TransactionException {
        return this.getCore(branchType).branchRegister(branchType, resourceId, clientId, xid, applicationData, lockKeys);
    }

    public void branchReport(BranchType branchType, String xid, long branchId, BranchStatus status, String applicationData) throws TransactionException {
        this.getCore(branchType).branchReport(branchType, xid, branchId, status, applicationData);
    }

    public boolean lockQuery(BranchType branchType, String resourceId, String xid, String lockKeys) throws TransactionException {
        return this.getCore(branchType).lockQuery(branchType, resourceId, xid, lockKeys);
    }

    @Override
    public BranchStatus branchCommit(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        return this.getCore(branchSession.getBranchType()).branchCommit(globalSession, branchSession);
    }

    @Override
    public BranchStatus branchRollback(GlobalSession globalSession, BranchSession branchSession) throws TransactionException {
        return this.getCore(branchSession.getBranchType()).branchRollback(globalSession, branchSession);
    }

    public String begin(String applicationId, String transactionServiceGroup, String name, int timeout) throws TransactionException {
        GlobalSession session = GlobalSession.createGlobalSession(applicationId, transactionServiceGroup, name, timeout);
        MDC.put((String)"X-TX-XID", (String)session.getXid());
        session.begin();
        MetricsPublisher.postSessionDoingEvent(session, false);
        return session.getXid();
    }

    public GlobalStatus commit(String xid) throws TransactionException {
        GlobalSession globalSession = SessionHolder.findGlobalSession(xid);
        if (globalSession == null) {
            return GlobalStatus.Finished;
        }
        if (globalSession.isTimeout()) {
            LOGGER.info("TC detected timeout, xid = {}", (Object)globalSession.getXid());
            return GlobalStatus.TimeoutRollbacking;
        }
        boolean shouldCommit = SessionHolder.lockAndExecute(globalSession, () -> {
            boolean shouldCommitNow = false;
            if (globalSession.getStatus() == GlobalStatus.Begin) {
                globalSession.close();
                if (globalSession.canBeCommittedAsync()) {
                    globalSession.asyncCommit();
                    MetricsPublisher.postSessionDoneEvent(globalSession, GlobalStatus.Committed, false, false);
                } else {
                    globalSession.changeGlobalStatus(GlobalStatus.Committing);
                    shouldCommitNow = true;
                }
                globalSession.clean();
            }
            return shouldCommitNow;
        });
        if (shouldCommit) {
            boolean success = this.doGlobalCommit(globalSession, false);
            if (success && globalSession.hasBranch() && globalSession.canBeCommittedAsync()) {
                globalSession.asyncCommit();
                return GlobalStatus.Committed;
            }
            return globalSession.getStatus();
        }
        return globalSession.getStatus() == GlobalStatus.AsyncCommitting ? GlobalStatus.Committed : globalSession.getStatus();
    }

    @Override
    public boolean doGlobalCommit(GlobalSession globalSession, boolean retrying) throws TransactionException {
        boolean success = true;
        MetricsPublisher.postSessionDoingEvent(globalSession, retrying);
        if (globalSession.isSaga()) {
            success = this.getCore(BranchType.SAGA).doGlobalCommit(globalSession, retrying);
        } else {
            List<BranchSession> branchSessions = globalSession.getSortedBranches();
            Boolean result = SessionHelper.forEach(branchSessions, branchSession -> {
                if (!retrying && branchSession.canBeCommittedAsync()) {
                    return BranchSessionHandler.CONTINUE;
                }
                BranchStatus currentStatus = branchSession.getStatus();
                if (currentStatus == BranchStatus.PhaseOne_Failed) {
                    SessionHelper.removeBranch(globalSession, branchSession, !retrying);
                    return BranchSessionHandler.CONTINUE;
                }
                try {
                    BranchStatus branchStatus = this.getCore(branchSession.getBranchType()).branchCommit(globalSession, branchSession);
                    if (this.isXaerNotaTimeout(globalSession, branchStatus)) {
                        LOGGER.info("Commit branch XAER_NOTA retry timeout, xid = {} branchId = {}", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                        branchStatus = BranchStatus.PhaseTwo_Committed;
                    }
                    switch (branchStatus) {
                        case PhaseTwo_Committed: {
                            SessionHelper.removeBranch(globalSession, branchSession, !retrying);
                            LOGGER.info("Commit branch transaction successfully, xid = {} branchId = {}", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                            return BranchSessionHandler.CONTINUE;
                        }
                        case PhaseTwo_CommitFailed_Unretryable: {
                            SessionHelper.endCommitFailed(globalSession, retrying);
                            LOGGER.error("Committing global transaction[{}] finally failed, caused by branch transaction[{}] commit failed.", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                            return false;
                        }
                    }
                    if (!retrying) {
                        globalSession.queueToRetryCommit();
                        return false;
                    }
                    if (globalSession.canBeCommittedAsync()) {
                        LOGGER.error("Committing branch transaction[{}], status:{} and will retry later", (Object)branchSession.getBranchId(), (Object)branchStatus);
                        return BranchSessionHandler.CONTINUE;
                    }
                    LOGGER.error("Committing global transaction[{}] failed, caused by branch transaction[{}] commit failed, will retry later.", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                    return false;
                }
                catch (Exception ex) {
                    String commitInfo = retrying ? "Global commit continue" : "Global commit failed";
                    StackTraceLogger.error((Logger)LOGGER, (Throwable)ex, (String)"Committing branch transaction exception:retrying={}, {}, {}", (Object[])new String[]{String.valueOf(retrying), branchSession.toString(), commitInfo});
                    if (!retrying) {
                        globalSession.queueToRetryCommit();
                        throw new TransactionException((Throwable)ex);
                    }
                    return BranchSessionHandler.CONTINUE;
                }
            }, PARALLEL_HANDLE_BRANCH && branchSessions.size() >= 2);
            if (result != null) {
                return result;
            }
            if (globalSession.hasBranch() && !globalSession.canBeCommittedAsync()) {
                LOGGER.info("Committing global transaction is NOT done, xid = {}.", (Object)globalSession.getXid());
                return false;
            }
        }
        if (success && globalSession.getBranchSessions().isEmpty()) {
            SessionHelper.endCommitted(globalSession, retrying);
            LOGGER.info("Committing global transaction is successfully done, xid = {}.", (Object)globalSession.getXid());
        }
        return success;
    }

    public GlobalStatus rollback(String xid) throws TransactionException {
        GlobalSession globalSession = SessionHolder.findGlobalSession(xid);
        if (globalSession == null) {
            return GlobalStatus.Finished;
        }
        boolean shouldRollBack = SessionHolder.lockAndExecute(globalSession, () -> {
            globalSession.close();
            if (globalSession.getStatus() == GlobalStatus.Begin) {
                globalSession.changeGlobalStatus(GlobalStatus.Rollbacking);
                return true;
            }
            return false;
        });
        if (!shouldRollBack) {
            return globalSession.getStatus();
        }
        boolean rollbackSuccess = this.doGlobalRollback(globalSession, false);
        return rollbackSuccess ? GlobalStatus.Rollbacked : globalSession.getStatus();
    }

    @Override
    public boolean doGlobalRollback(GlobalSession globalSession, boolean retrying) throws TransactionException {
        boolean success = true;
        MetricsPublisher.postSessionDoingEvent(globalSession, retrying);
        if (globalSession.isSaga()) {
            success = this.getCore(BranchType.SAGA).doGlobalRollback(globalSession, retrying);
        } else {
            List<BranchSession> branchSessions = globalSession.getSortedBranches();
            Boolean result = SessionHelper.forEach(branchSessions, branchSession -> {
                BranchStatus currentBranchStatus = branchSession.getStatus();
                if (currentBranchStatus == BranchStatus.PhaseOne_Failed) {
                    SessionHelper.removeBranch(globalSession, branchSession, !retrying);
                    return BranchSessionHandler.CONTINUE;
                }
                try {
                    BranchStatus branchStatus = this.branchRollback(globalSession, branchSession);
                    if (this.isXaerNotaTimeout(globalSession, branchStatus)) {
                        LOGGER.info("Rollback branch XAER_NOTA retry timeout, xid = {} branchId = {}", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                        branchStatus = BranchStatus.PhaseTwo_Rollbacked;
                    }
                    switch (branchStatus) {
                        case PhaseTwo_Rollbacked: {
                            SessionHelper.removeBranch(globalSession, branchSession, !retrying);
                            LOGGER.info("Rollback branch transaction successfully, xid = {} branchId = {}", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                            return BranchSessionHandler.CONTINUE;
                        }
                        case PhaseTwo_RollbackFailed_Unretryable: {
                            SessionHelper.endRollbackFailed(globalSession, retrying);
                            LOGGER.error("Rollback branch transaction fail and stop retry, xid = {} branchId = {}", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                            return false;
                        }
                    }
                    LOGGER.error("Rollback branch transaction fail and will retry, xid = {} branchId = {}", (Object)globalSession.getXid(), (Object)branchSession.getBranchId());
                    if (!retrying) {
                        globalSession.queueToRetryRollback();
                    }
                    return false;
                }
                catch (Exception ex) {
                    StackTraceLogger.error((Logger)LOGGER, (Throwable)ex, (String)"Rollback branch transaction exception, xid = {} ,branchId = {} ,retrying={} ,exception = {}, global rollback failed", (Object[])new String[]{globalSession.getXid(), String.valueOf(branchSession.getBranchId()), String.valueOf(retrying), ex.getMessage()});
                    if (!retrying) {
                        globalSession.queueToRetryRollback();
                    }
                    throw new TransactionException((Throwable)ex);
                }
            }, PARALLEL_HANDLE_BRANCH && branchSessions.size() >= 2);
            if (result != null) {
                return result;
            }
        }
        if (success) {
            SessionHelper.endRollbacked(globalSession, retrying);
            LOGGER.info("Rollback global transaction successfully, xid = {}.", (Object)globalSession.getXid());
        }
        return success;
    }

    public GlobalStatus getStatus(String xid) throws TransactionException {
        GlobalSession globalSession = SessionHolder.findGlobalSession(xid, false);
        if (globalSession == null) {
            return GlobalStatus.Finished;
        }
        return globalSession.getStatus();
    }

    public GlobalStatus globalReport(String xid, GlobalStatus globalStatus) throws TransactionException {
        GlobalSession globalSession = SessionHolder.findGlobalSession(xid);
        if (globalSession == null) {
            return globalStatus;
        }
        this.doGlobalReport(globalSession, xid, globalStatus);
        return globalSession.getStatus();
    }

    @Override
    public void doGlobalReport(GlobalSession globalSession, String xid, GlobalStatus globalStatus) throws TransactionException {
        if (globalSession.isSaga()) {
            this.getCore(BranchType.SAGA).doGlobalReport(globalSession, xid, globalStatus);
        }
    }

    private boolean isXaerNotaTimeout(GlobalSession globalSession, BranchStatus branchStatus) {
        if (BranchStatus.PhaseTwo_CommitFailed_XAER_NOTA_Retryable.equals((Object)branchStatus) || BranchStatus.PhaseTwo_RollbackFailed_XAER_NOTA_Retryable.equals((Object)branchStatus)) {
            return System.currentTimeMillis() > globalSession.getBeginTime() + (long)globalSession.getTimeout() + (long)Math.max(RETRY_XAER_NOTA_TIMEOUT, globalSession.getTimeout());
        }
        return false;
    }
}

