/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.cluster.raft.execute.global;

import io.seata.core.model.GlobalStatus;
import io.seata.core.model.LockStatus;
import io.seata.server.cluster.raft.execute.AbstractRaftMsgExecute;
import io.seata.server.cluster.raft.sync.msg.RaftBaseMsg;
import io.seata.server.cluster.raft.sync.msg.RaftGlobalSessionSyncMsg;
import io.seata.server.cluster.raft.sync.msg.dto.GlobalTransactionDTO;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionHolder;
import io.seata.server.storage.raft.session.RaftSessionManager;

public class UpdateGlobalSessionExecute
extends AbstractRaftMsgExecute {
    @Override
    public Boolean execute(RaftBaseMsg syncMsg) throws Throwable {
        GlobalTransactionDTO globalTransactionDTO;
        RaftGlobalSessionSyncMsg sessionSyncMsg = (RaftGlobalSessionSyncMsg)syncMsg;
        RaftSessionManager raftSessionManager = (RaftSessionManager)SessionHolder.getRootSessionManager(sessionSyncMsg.getGroup());
        GlobalSession globalSession = raftSessionManager.findGlobalSession((globalTransactionDTO = sessionSyncMsg.getGlobalSession()).getXid());
        if (globalSession != null) {
            globalSession.setStatus(GlobalStatus.get((int)globalTransactionDTO.getStatus()));
            if (GlobalStatus.RollbackRetrying.equals((Object)globalSession.getStatus()) || GlobalStatus.Rollbacking.equals((Object)globalSession.getStatus()) || GlobalStatus.TimeoutRollbacking.equals((Object)globalSession.getStatus())) {
                globalSession.getBranchSessions().parallelStream().forEach(branchSession -> branchSession.setLockStatus(LockStatus.Rollbacking));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("xid: {}, change status: {}", (Object)globalSession.getXid(), (Object)globalSession.getStatus());
            }
        }
        return true;
    }
}

