/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.cluster.raft.execute.global;

import io.seata.common.thread.NamedThreadFactory;
import io.seata.core.exception.TransactionException;
import io.seata.server.cluster.raft.execute.AbstractRaftMsgExecute;
import io.seata.server.cluster.raft.sync.msg.RaftBaseMsg;
import io.seata.server.cluster.raft.sync.msg.RaftGlobalSessionSyncMsg;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionHolder;
import io.seata.server.storage.raft.session.RaftSessionManager;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RemoveGlobalSessionExecute
extends AbstractRaftMsgExecute {
    private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(2048), (ThreadFactory)new NamedThreadFactory("RemoveGlobalSessionExecute", 1), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public Boolean execute(RaftBaseMsg syncMsg) throws Throwable {
        RaftGlobalSessionSyncMsg sessionSyncMsg = (RaftGlobalSessionSyncMsg)syncMsg;
        RaftSessionManager raftSessionManager = (RaftSessionManager)SessionHolder.getRootSessionManager(sessionSyncMsg.getGroup());
        Optional.ofNullable(raftSessionManager.findGlobalSession(sessionSyncMsg.getGlobalSession().getXid())).ifPresent(globalSession -> {
            try {
                this.raftLockManager.localReleaseGlobalSessionLock((GlobalSession)globalSession);
                EXECUTOR.execute(() -> {
                    try {
                        raftSessionManager.removeGlobalSession((GlobalSession)globalSession);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("remove session xid: {}", (Object)globalSession.getXid());
                        }
                    }
                    catch (TransactionException e) {
                        this.logger.error("remove global fail error:{}", (Object)e.getMessage());
                    }
                });
            }
            catch (TransactionException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        });
        return true;
    }
}

