/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.cluster.raft.execute.branch;

import io.seata.server.cluster.raft.execute.AbstractRaftMsgExecute;
import io.seata.server.cluster.raft.sync.msg.RaftBaseMsg;
import io.seata.server.cluster.raft.sync.msg.RaftBranchSessionSyncMsg;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionHolder;
import io.seata.server.storage.raft.session.RaftSessionManager;

public class RemoveBranchSessionExecute
extends AbstractRaftMsgExecute {
    @Override
    public Boolean execute(RaftBaseMsg syncMsg) throws Throwable {
        RaftBranchSessionSyncMsg sessionSyncMsg = (RaftBranchSessionSyncMsg)syncMsg;
        RaftSessionManager raftSessionManager = (RaftSessionManager)SessionHolder.getRootSessionManager(sessionSyncMsg.getGroup());
        GlobalSession globalSession = raftSessionManager.findGlobalSession(sessionSyncMsg.getBranchSession().getXid());
        if (globalSession != null) {
            BranchSession branchSession = globalSession.getBranch(sessionSyncMsg.getBranchSession().getBranchId());
            if (branchSession != null) {
                this.raftLockManager.localReleaseLock(branchSession);
                globalSession.remove(branchSession);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("removeBranch xid: {},branchId: {}", (Object)globalSession.getXid(), (Object)sessionSyncMsg.getBranchSession().getBranchId());
            }
        }
        return true;
    }
}

