/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.cluster.raft.execute.branch;

import io.seata.server.cluster.raft.execute.AbstractRaftMsgExecute;
import io.seata.server.cluster.raft.sync.msg.RaftBaseMsg;
import io.seata.server.cluster.raft.sync.msg.RaftBranchSessionSyncMsg;
import io.seata.server.cluster.raft.sync.msg.dto.BranchTransactionDTO;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionHolder;
import io.seata.server.storage.SessionConverter;
import io.seata.server.storage.raft.session.RaftSessionManager;

public class AddBranchSessionExecute
extends AbstractRaftMsgExecute {
    @Override
    public Boolean execute(RaftBaseMsg syncMsg) throws Throwable {
        RaftBranchSessionSyncMsg sessionSyncMsg = (RaftBranchSessionSyncMsg)syncMsg;
        RaftSessionManager raftSessionManager = (RaftSessionManager)SessionHolder.getRootSessionManager(sessionSyncMsg.getGroup());
        BranchTransactionDTO branchTransactionDTO = sessionSyncMsg.getBranchSession();
        GlobalSession globalSession = raftSessionManager.findGlobalSession(branchTransactionDTO.getXid());
        BranchSession branchSession = SessionConverter.convertBranchSession(branchTransactionDTO);
        branchSession.lock();
        globalSession.add(branchSession);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("addBranch xid: {},branchId: {}", (Object)branchTransactionDTO.getXid(), (Object)branchTransactionDTO.getBranchId());
        }
        return true;
    }
}

