/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.cluster.raft;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Iterator;
import com.alipay.sofa.jraft.RouteTable;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.core.StateMachineAdapter;
import com.alipay.sofa.jraft.entity.LeaderChangeContext;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import io.seata.common.XID;
import io.seata.common.holder.ObjectHolder;
import io.seata.common.metadata.ClusterRole;
import io.seata.common.metadata.Node;
import io.seata.common.store.StoreMode;
import io.seata.common.util.StringUtils;
import io.seata.server.cluster.listener.ClusterChangeEvent;
import io.seata.server.cluster.raft.RaftServerFactory;
import io.seata.server.cluster.raft.context.SeataClusterContext;
import io.seata.server.cluster.raft.execute.RaftMsgExecute;
import io.seata.server.cluster.raft.execute.branch.AddBranchSessionExecute;
import io.seata.server.cluster.raft.execute.branch.RemoveBranchSessionExecute;
import io.seata.server.cluster.raft.execute.branch.UpdateBranchSessionExecute;
import io.seata.server.cluster.raft.execute.global.AddGlobalSessionExecute;
import io.seata.server.cluster.raft.execute.global.RemoveGlobalSessionExecute;
import io.seata.server.cluster.raft.execute.global.UpdateGlobalSessionExecute;
import io.seata.server.cluster.raft.execute.lock.BranchReleaseLockExecute;
import io.seata.server.cluster.raft.execute.lock.GlobalReleaseLockExecute;
import io.seata.server.cluster.raft.snapshot.StoreSnapshotFile;
import io.seata.server.cluster.raft.snapshot.metadata.LeaderMetadataSnapshotFile;
import io.seata.server.cluster.raft.snapshot.session.SessionSnapshotFile;
import io.seata.server.cluster.raft.sync.RaftSyncMessageSerializer;
import io.seata.server.cluster.raft.sync.msg.RaftBaseMsg;
import io.seata.server.cluster.raft.sync.msg.RaftClusterMetadataMsg;
import io.seata.server.cluster.raft.sync.msg.RaftSyncMsgType;
import io.seata.server.cluster.raft.sync.msg.dto.RaftClusterMetadata;
import io.seata.server.cluster.raft.util.RaftTaskUtil;
import io.seata.server.session.SessionHolder;
import io.seata.server.store.StoreConfig;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.env.Environment;

public class RaftStateMachine
extends StateMachineAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftStateMachine.class);
    private final String mode;
    private final String group;
    private final List<StoreSnapshotFile> snapshotFiles = new ArrayList<StoreSnapshotFile>();
    private static final Map<RaftSyncMsgType, RaftMsgExecute<?>> EXECUTES = new HashMap();
    private volatile RaftClusterMetadata raftClusterMetadata;
    private final AtomicLong leaderTerm = new AtomicLong(-1L);
    private final AtomicLong currentTerm = new AtomicLong(-1L);

    public boolean isLeader() {
        return this.leaderTerm.get() > 0L;
    }

    public RaftStateMachine(String group) {
        this.group = group;
        this.mode = StoreConfig.getSessionMode().getName();
        EXECUTES.put(RaftSyncMsgType.REFRESH_CLUSTER_METADATA, syncMsg -> {
            this.refreshClusterMetadata(syncMsg);
            return null;
        });
        this.registryStoreSnapshotFile(new LeaderMetadataSnapshotFile(group));
        if (StoreMode.RAFT.getName().equalsIgnoreCase(this.mode)) {
            this.registryStoreSnapshotFile(new SessionSnapshotFile(group));
            EXECUTES.put(RaftSyncMsgType.ADD_GLOBAL_SESSION, new AddGlobalSessionExecute());
            EXECUTES.put(RaftSyncMsgType.ADD_BRANCH_SESSION, new AddBranchSessionExecute());
            EXECUTES.put(RaftSyncMsgType.REMOVE_BRANCH_SESSION, new RemoveBranchSessionExecute());
            EXECUTES.put(RaftSyncMsgType.UPDATE_GLOBAL_SESSION_STATUS, new UpdateGlobalSessionExecute());
            EXECUTES.put(RaftSyncMsgType.RELEASE_GLOBAL_SESSION_LOCK, new GlobalReleaseLockExecute());
            EXECUTES.put(RaftSyncMsgType.REMOVE_GLOBAL_SESSION, new RemoveGlobalSessionExecute());
            EXECUTES.put(RaftSyncMsgType.UPDATE_BRANCH_SESSION_STATUS, new UpdateBranchSessionExecute());
            EXECUTES.put(RaftSyncMsgType.RELEASE_BRANCH_SESSION_LOCK, new BranchReleaseLockExecute());
        }
    }

    public void onApply(Iterator iterator) {
        while (iterator.hasNext()) {
            Closure done = iterator.done();
            if (done != null) {
                done.run(Status.OK());
            } else {
                ByteBuffer byteBuffer = iterator.getData();
                if (byteBuffer != null && byteBuffer.hasRemaining()) {
                    RaftBaseMsg msg = (RaftBaseMsg)RaftSyncMessageSerializer.decode(byteBuffer.array()).getBody();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("sync msg: {}", (Object)msg);
                    }
                    this.onExecuteRaft(msg);
                }
            }
            iterator.next();
        }
    }

    public void onSnapshotSave(SnapshotWriter writer, Closure done) {
        if (!StringUtils.equals((String)StoreConfig.SessionMode.RAFT.getName(), (String)this.mode)) {
            done.run(Status.OK());
            return;
        }
        long current = System.currentTimeMillis();
        for (StoreSnapshotFile snapshotFile : this.snapshotFiles) {
            Status status = snapshotFile.save(writer);
            if (status.isOk()) continue;
            done.run(status);
            return;
        }
        LOGGER.info("groupId: {}, onSnapshotSave cost: {} ms.", (Object)this.group, (Object)(System.currentTimeMillis() - current));
        done.run(Status.OK());
    }

    public boolean onSnapshotLoad(SnapshotReader reader) {
        if (!StringUtils.equals((String)StoreConfig.SessionMode.RAFT.getName(), (String)this.mode)) {
            return true;
        }
        if (this.isLeader()) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Leader is not supposed to load snapshot");
            }
            return false;
        }
        long current = System.currentTimeMillis();
        for (StoreSnapshotFile snapshotFile : this.snapshotFiles) {
            if (snapshotFile.load(reader)) continue;
            return false;
        }
        LOGGER.info("groupId: {}, onSnapshotLoad cost: {} ms.", (Object)this.group, (Object)(System.currentTimeMillis() - current));
        return true;
    }

    public void onLeaderStart(long term) {
        boolean leader = this.isLeader();
        this.leaderTerm.set(term);
        LOGGER.info("groupId: {}, onLeaderStart: term={}.", (Object)this.group, (Object)term);
        this.currentTerm.set(term);
        SeataClusterContext.bindGroup(this.group);
        this.syncMetadata();
        if (!leader && RaftServerFactory.getInstance().isRaftMode().booleanValue()) {
            CompletableFuture.runAsync(() -> {
                LOGGER.info("reload session, groupId: {}, session map size: {} ", (Object)this.group, (Object)SessionHolder.getRootSessionManager().allSessions().size());
                SeataClusterContext.bindGroup(this.group);
                try {
                    SessionHolder.reload(SessionHolder.getRootSessionManager().allSessions(), StoreConfig.SessionMode.RAFT, false);
                }
                finally {
                    SeataClusterContext.unbindGroup();
                }
            });
        }
    }

    public void onLeaderStop(Status status) {
        this.leaderTerm.set(-1L);
        LOGGER.info("groupId: {}, onLeaderStop: status={}.", (Object)this.group, (Object)status);
    }

    public void onStopFollowing(LeaderChangeContext ctx) {
        LOGGER.info("groupId: {}, onStopFollowing: {}.", (Object)this.group, (Object)ctx);
    }

    public void onStartFollowing(LeaderChangeContext ctx) {
        LOGGER.info("groupId: {}, onStartFollowing: {}.", (Object)this.group, (Object)ctx);
        this.currentTerm.set(ctx.getTerm());
    }

    public void onConfigurationCommitted(Configuration conf) {
        LOGGER.info("groupId: {}, onConfigurationCommitted: {}.", (Object)this.group, (Object)conf);
        this.syncMetadata();
        RouteTable.getInstance().updateConfiguration(this.group, conf);
    }

    private void syncMetadata() {
        if (this.isLeader()) {
            SeataClusterContext.bindGroup(this.group);
            try {
                RaftClusterMetadataMsg raftClusterMetadataMsg = new RaftClusterMetadataMsg(this.createNewRaftClusterMetadata());
                RaftTaskUtil.createTask(status -> this.refreshClusterMetadata(raftClusterMetadataMsg), raftClusterMetadataMsg, null);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            finally {
                SeataClusterContext.unbindGroup();
            }
        }
    }

    private void onExecuteRaft(RaftBaseMsg msg) {
        RaftMsgExecute<?> execute = EXECUTES.get((Object)msg.getMsgType());
        if (execute == null) {
            throw new RuntimeException("the state machine does not allow events that cannot be executed, please feedback the information to the Seata community !!! msg: " + msg);
        }
        try {
            execute.execute(msg);
        }
        catch (Throwable e) {
            LOGGER.error("Message synchronization failure: {}, msgType: {}", new Object[]{e.getMessage(), msg.getMsgType(), e});
            throw new RuntimeException(e);
        }
    }

    public AtomicLong getCurrentTerm() {
        return this.currentTerm;
    }

    public void registryStoreSnapshotFile(StoreSnapshotFile storeSnapshotFile) {
        this.snapshotFiles.add(storeSnapshotFile);
    }

    public RaftClusterMetadata getRaftLeaderMetadata() {
        return this.raftClusterMetadata;
    }

    public void setRaftLeaderMetadata(RaftClusterMetadata raftClusterMetadata) {
        this.raftClusterMetadata = raftClusterMetadata;
    }

    public RaftClusterMetadata createNewRaftClusterMetadata() {
        RaftClusterMetadata metadata = new RaftClusterMetadata(this.currentTerm.get());
        Node leader = metadata.createNode(XID.getIpAddress(), XID.getPort(), Integer.parseInt(((Environment)ObjectHolder.INSTANCE.getObject("springConfigurableEnvironment")).getProperty("server.port", String.valueOf(8088))), this.group, Collections.emptyMap());
        leader.setRole(ClusterRole.LEADER);
        metadata.setLeader(leader);
        Configuration configuration = RouteTable.getInstance().getConfiguration(this.group);
        List<Node> learners = configuration.getLearners().stream().map(learner -> {
            int nettyPort = learner.getPort() - 1000;
            Node learnerNode = metadata.createNode(learner.getIp(), nettyPort, nettyPort - 1000, this.group, Collections.emptyMap());
            learnerNode.setRole(ClusterRole.LEARNER);
            return learnerNode;
        }).collect(Collectors.toList());
        metadata.setLearner(learners);
        List<Node> followers = configuration.getPeers().stream().map(follower -> {
            int nettyPort = follower.getPort() - 1000;
            Node followerNode = metadata.createNode(follower.getIp(), nettyPort, nettyPort - 1000, this.group, Collections.emptyMap());
            followerNode.setRole(ClusterRole.FOLLOWER);
            return followerNode;
        }).collect(Collectors.toList());
        metadata.setFollowers(followers);
        return metadata;
    }

    public void refreshClusterMetadata(RaftBaseMsg syncMsg) {
        this.raftClusterMetadata = ((RaftClusterMetadataMsg)syncMsg).getRaftClusterMetadata();
        ((ApplicationEventPublisher)ObjectHolder.INSTANCE.getObject("springApplicationContext")).publishEvent((ApplicationEvent)new ClusterChangeEvent((Object)this, this.group, this.raftClusterMetadata.getTerm(), this.isLeader()));
        LOGGER.info("groupId: {}, refresh cluster metadata: {}", (Object)this.group, (Object)this.raftClusterMetadata);
    }
}

