/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server;

import io.seata.common.XID;
import io.seata.common.holder.ObjectHolder;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.NetUtil;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.core.rpc.RemotingServer;
import io.seata.core.rpc.TransactionMessageHandler;
import io.seata.core.rpc.netty.NettyRemotingServer;
import io.seata.core.rpc.netty.NettyServerConfig;
import io.seata.server.ParameterParser;
import io.seata.server.ServerRunner;
import io.seata.server.UUIDGenerator;
import io.seata.server.coordinator.DefaultCoordinator;
import io.seata.server.lock.LockerManagerFactory;
import io.seata.server.metrics.MetricsManager;
import io.seata.server.session.SessionHolder;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class Server {
    public static void start(String[] args) {
        ParameterParser parameterParser = new ParameterParser(args);
        MetricsManager.get().init();
        ThreadPoolExecutor workingThreads = new ThreadPoolExecutor(NettyServerConfig.getMinServerPoolSize(), NettyServerConfig.getMaxServerPoolSize(), NettyServerConfig.getKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(NettyServerConfig.getMaxTaskQueueSize()), (ThreadFactory)new NamedThreadFactory("ServerHandlerThread", NettyServerConfig.getMaxServerPoolSize()), new ThreadPoolExecutor.CallerRunsPolicy());
        if (NetUtil.isValidIp((String)parameterParser.getHost(), (boolean)false)) {
            XID.setIpAddress((String)parameterParser.getHost());
        } else {
            String preferredNetworks = ConfigurationFactory.getInstance().getConfig("registry.preferredNetworks");
            if (StringUtils.isNotBlank((String)preferredNetworks)) {
                XID.setIpAddress((String)NetUtil.getLocalIp((String[])preferredNetworks.split(";")));
            } else {
                XID.setIpAddress((String)NetUtil.getLocalIp((String[])new String[0]));
            }
        }
        NettyRemotingServer nettyRemotingServer = new NettyRemotingServer(workingThreads);
        XID.setPort((int)nettyRemotingServer.getListenPort());
        UUIDGenerator.init(parameterParser.getServerNode());
        ConfigurableListableBeanFactory beanFactory = ((GenericWebApplicationContext)ObjectHolder.INSTANCE.getObject("springApplicationContext")).getBeanFactory();
        DefaultCoordinator coordinator = DefaultCoordinator.getInstance((RemotingServer)nettyRemotingServer);
        if (coordinator instanceof ApplicationListener) {
            beanFactory.registerSingleton(NettyRemotingServer.class.getName(), (Object)nettyRemotingServer);
            beanFactory.registerSingleton(DefaultCoordinator.class.getName(), (Object)coordinator);
            ((GenericWebApplicationContext)ObjectHolder.INSTANCE.getObject("springApplicationContext")).addApplicationListener((ApplicationListener)coordinator);
        }
        SessionHolder.init();
        LockerManagerFactory.init();
        coordinator.init();
        nettyRemotingServer.setHandler((TransactionMessageHandler)coordinator);
        ServerRunner.addDisposable(coordinator);
        nettyRemotingServer.init();
    }
}

