/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.lock;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.server.lock.LockManager;
import io.seata.server.store.StoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockerManagerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockerManagerFactory.class);
    private static final Configuration CONFIG = ConfigurationFactory.getInstance();
    private static volatile LockManager LOCK_MANAGER;

    public static LockManager getLockManager() {
        if (LOCK_MANAGER == null) {
            LockerManagerFactory.init();
        }
        return LOCK_MANAGER;
    }

    public static void init() {
        LockerManagerFactory.init(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(StoreConfig.LockMode lockMode) {
        if (LOCK_MANAGER != null) return;
        Class<LockerManagerFactory> clazz = LockerManagerFactory.class;
        synchronized (LockerManagerFactory.class) {
            if (LOCK_MANAGER != null) return;
            if (null == lockMode) {
                lockMode = StoreConfig.getLockMode();
            }
            LOGGER.info("use lock store mode: {}", (Object)lockMode.getName());
            if (null == StoreConfig.StoreMode.get(lockMode.name())) return;
            LOCK_MANAGER = (LockManager)EnhancedServiceLoader.load(LockManager.class, (String)lockMode.getName());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

