/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.coordinator;

import io.netty.channel.Channel;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.CollectionUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.GlobalStatus;
import io.seata.core.protocol.AbstractMessage;
import io.seata.core.protocol.AbstractResultMessage;
import io.seata.core.protocol.transaction.AbstractTransactionRequestToTC;
import io.seata.core.protocol.transaction.AbstractTransactionResponse;
import io.seata.core.protocol.transaction.BranchRegisterRequest;
import io.seata.core.protocol.transaction.BranchRegisterResponse;
import io.seata.core.protocol.transaction.BranchReportRequest;
import io.seata.core.protocol.transaction.BranchReportResponse;
import io.seata.core.protocol.transaction.GlobalBeginRequest;
import io.seata.core.protocol.transaction.GlobalBeginResponse;
import io.seata.core.protocol.transaction.GlobalCommitRequest;
import io.seata.core.protocol.transaction.GlobalCommitResponse;
import io.seata.core.protocol.transaction.GlobalLockQueryRequest;
import io.seata.core.protocol.transaction.GlobalLockQueryResponse;
import io.seata.core.protocol.transaction.GlobalReportRequest;
import io.seata.core.protocol.transaction.GlobalReportResponse;
import io.seata.core.protocol.transaction.GlobalRollbackRequest;
import io.seata.core.protocol.transaction.GlobalRollbackResponse;
import io.seata.core.protocol.transaction.GlobalStatusRequest;
import io.seata.core.protocol.transaction.GlobalStatusResponse;
import io.seata.core.protocol.transaction.TCInboundHandler;
import io.seata.core.protocol.transaction.UndoLogDeleteRequest;
import io.seata.core.rpc.Disposable;
import io.seata.core.rpc.RemotingServer;
import io.seata.core.rpc.RpcContext;
import io.seata.core.rpc.TransactionMessageHandler;
import io.seata.core.rpc.netty.ChannelManager;
import io.seata.core.rpc.netty.NettyRemotingServer;
import io.seata.server.AbstractTCInboundHandler;
import io.seata.server.coordinator.DefaultCore;
import io.seata.server.metrics.MetricsPublisher;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionCondition;
import io.seata.server.session.SessionHelper;
import io.seata.server.session.SessionHolder;
import io.seata.server.store.StoreConfig;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class DefaultCoordinator
extends AbstractTCInboundHandler
implements TransactionMessageHandler,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCoordinator.class);
    private static final int TIMED_TASK_SHUTDOWN_MAX_WAIT_MILLS = 5000;
    protected static final long COMMITTING_RETRY_PERIOD = CONFIG.getLong("server.recovery.committingRetryPeriod", 1000L);
    protected static final long ASYNC_COMMITTING_RETRY_PERIOD = CONFIG.getLong("server.recovery.asyncCommittingRetryPeriod", 1000L);
    protected static final long ROLLBACKING_RETRY_PERIOD = CONFIG.getLong("server.recovery.rollbackingRetryPeriod", 1000L);
    protected static final long TIMEOUT_RETRY_PERIOD = CONFIG.getLong("server.recovery.timeoutRetryPeriod", 1000L);
    protected static final long UNDO_LOG_DELETE_PERIOD = CONFIG.getLong("server.undo.logDeletePeriod", 86400000L);
    protected static final long UNDO_LOG_DELAY_DELETE_PERIOD = 180000L;
    private static final int ALWAYS_RETRY_BOUNDARY = 0;
    private static final int DEFAULT_BRANCH_ASYNC_QUEUE_SIZE = 5000;
    private static final int BRANCH_ASYNC_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2;
    private static final long MAX_COMMIT_RETRY_TIMEOUT = ConfigurationFactory.getInstance().getLong("server.maxCommitRetryTimeout", -1L);
    private static final long MAX_ROLLBACK_RETRY_TIMEOUT = ConfigurationFactory.getInstance().getLong("server.maxRollbackRetryTimeout", -1L);
    private static final boolean ROLLBACK_RETRY_TIMEOUT_UNLOCK_ENABLE = ConfigurationFactory.getInstance().getBoolean("server.rollbackRetryTimeoutUnlockEnable", false);
    private final ScheduledThreadPoolExecutor retryRollbacking = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("RetryRollbacking", 1));
    private final ScheduledThreadPoolExecutor retryCommitting = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("RetryCommitting", 1));
    private final ScheduledThreadPoolExecutor asyncCommitting = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("AsyncCommitting", 1));
    private final ScheduledThreadPoolExecutor timeoutCheck = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("TxTimeoutCheck", 1));
    private final ScheduledThreadPoolExecutor undoLogDelete = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("UndologDelete", 1));
    private final GlobalStatus[] rollbackingStatuses = new GlobalStatus[]{GlobalStatus.TimeoutRollbacking, GlobalStatus.TimeoutRollbackRetrying, GlobalStatus.RollbackRetrying, GlobalStatus.Rollbacking};
    private final GlobalStatus[] retryCommittingStatuses = new GlobalStatus[]{GlobalStatus.Committing, GlobalStatus.CommitRetrying, GlobalStatus.Committed};
    private final ThreadPoolExecutor branchRemoveExecutor;
    private RemotingServer remotingServer;
    private final DefaultCore core;
    private static volatile DefaultCoordinator instance;

    private DefaultCoordinator(RemotingServer remotingServer) {
        if (remotingServer == null) {
            throw new IllegalArgumentException("RemotingServer not allowed be null.");
        }
        this.remotingServer = remotingServer;
        this.core = new DefaultCore(remotingServer);
        boolean enableBranchAsyncRemove = CONFIG.getBoolean("server.session.enableBranchAsyncRemove", false);
        this.branchRemoveExecutor = enableBranchAsyncRemove && StoreConfig.getSessionMode() != StoreConfig.SessionMode.FILE ? new ThreadPoolExecutor(BRANCH_ASYNC_POOL_SIZE, BRANCH_ASYNC_POOL_SIZE, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(CONFIG.getInt("server.session.branchAsyncQueueSize", 5000)), (ThreadFactory)new NamedThreadFactory("branchSessionRemove", BRANCH_ASYNC_POOL_SIZE), new ThreadPoolExecutor.CallerRunsPolicy()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultCoordinator getInstance(RemotingServer remotingServer) {
        if (null != instance) return instance;
        Class<DefaultCoordinator> clazz = DefaultCoordinator.class;
        synchronized (DefaultCoordinator.class) {
            if (null != instance) return instance;
            instance = new DefaultCoordinator(remotingServer);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static DefaultCoordinator getInstance() {
        if (null == instance) {
            throw new IllegalArgumentException("The instance has not been created.");
        }
        return instance;
    }

    public void doBranchRemoveAsync(GlobalSession globalSession, BranchSession branchSession) {
        if (globalSession == null) {
            return;
        }
        this.branchRemoveExecutor.execute(new BranchRemoveTask(globalSession, branchSession));
    }

    public void doBranchRemoveAllAsync(GlobalSession globalSession) {
        if (globalSession == null) {
            return;
        }
        this.branchRemoveExecutor.execute(new BranchRemoveTask(globalSession));
    }

    @Override
    protected void doGlobalBegin(GlobalBeginRequest request, GlobalBeginResponse response, RpcContext rpcContext) throws TransactionException {
        response.setXid(this.core.begin(rpcContext.getApplicationId(), rpcContext.getTransactionServiceGroup(), request.getTransactionName(), request.getTimeout()));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Begin new global transaction applicationId: {},transactionServiceGroup: {}, transactionName: {},timeout:{},xid:{}", new Object[]{rpcContext.getApplicationId(), rpcContext.getTransactionServiceGroup(), request.getTransactionName(), request.getTimeout(), response.getXid()});
        }
    }

    @Override
    protected void doGlobalCommit(GlobalCommitRequest request, GlobalCommitResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setGlobalStatus(this.core.commit(request.getXid()));
    }

    @Override
    protected void doGlobalRollback(GlobalRollbackRequest request, GlobalRollbackResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setGlobalStatus(this.core.rollback(request.getXid()));
    }

    @Override
    protected void doGlobalStatus(GlobalStatusRequest request, GlobalStatusResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setGlobalStatus(this.core.getStatus(request.getXid()));
    }

    @Override
    protected void doGlobalReport(GlobalReportRequest request, GlobalReportResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setGlobalStatus(this.core.globalReport(request.getXid(), request.getGlobalStatus()));
    }

    @Override
    protected void doBranchRegister(BranchRegisterRequest request, BranchRegisterResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setBranchId(this.core.branchRegister(request.getBranchType(), request.getResourceId(), rpcContext.getClientId(), request.getXid(), request.getApplicationData(), request.getLockKey()).longValue());
    }

    @Override
    protected void doBranchReport(BranchReportRequest request, BranchReportResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        MDC.put((String)"X-TX-BRANCH-ID", (String)String.valueOf(request.getBranchId()));
        this.core.branchReport(request.getBranchType(), request.getXid(), request.getBranchId(), request.getStatus(), request.getApplicationData());
    }

    @Override
    protected void doLockCheck(GlobalLockQueryRequest request, GlobalLockQueryResponse response, RpcContext rpcContext) throws TransactionException {
        MDC.put((String)"X-TX-XID", (String)request.getXid());
        response.setLockable(this.core.lockQuery(request.getBranchType(), request.getResourceId(), request.getXid(), request.getLockKey()));
    }

    protected void timeoutCheck() {
        SessionCondition sessionCondition = new SessionCondition(GlobalStatus.Begin);
        sessionCondition.setLazyLoadBranch(true);
        List<GlobalSession> beginGlobalsessions = SessionHolder.getRootSessionManager().findGlobalSessions(sessionCondition);
        if (CollectionUtils.isEmpty(beginGlobalsessions)) {
            return;
        }
        if (!beginGlobalsessions.isEmpty() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Global transaction timeout check begin, size: {}", (Object)beginGlobalsessions.size());
        }
        SessionHelper.forEach(beginGlobalsessions, globalSession -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(globalSession.getXid() + " " + globalSession.getStatus() + " " + globalSession.getBeginTime() + " " + globalSession.getTimeout());
            }
            SessionHolder.lockAndExecute(globalSession, () -> {
                if (globalSession.getStatus() != GlobalStatus.Begin || !globalSession.isTimeout()) {
                    return false;
                }
                LOGGER.warn("Global transaction[{}] is timeout and will be rollback,transaction begin time:{} and now:{}", new Object[]{globalSession.getXid(), DateFormatUtils.ISO_DATE_FORMAT.format(globalSession.getBeginTime()), DateFormatUtils.ISO_DATE_FORMAT.format(System.currentTimeMillis())});
                globalSession.addSessionLifecycleListener(SessionHolder.getRootSessionManager());
                globalSession.close();
                globalSession.setStatus(GlobalStatus.TimeoutRollbacking);
                globalSession.addSessionLifecycleListener(SessionHolder.getRetryRollbackingSessionManager());
                SessionHolder.getRetryRollbackingSessionManager().addGlobalSession(globalSession);
                MetricsPublisher.postSessionDoingEvent(globalSession, GlobalStatus.TimeoutRollbacking.name(), false, false);
                return true;
            });
        });
        if (!beginGlobalsessions.isEmpty() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Global transaction timeout check end. ");
        }
    }

    protected void handleRetryRollbacking() {
        SessionCondition sessionCondition = new SessionCondition(this.rollbackingStatuses);
        sessionCondition.setLazyLoadBranch(true);
        List<GlobalSession> rollbackingSessions = SessionHolder.getRetryRollbackingSessionManager().findGlobalSessions(sessionCondition);
        if (CollectionUtils.isEmpty(rollbackingSessions)) {
            return;
        }
        long now = System.currentTimeMillis();
        SessionHelper.forEach(rollbackingSessions, rollbackingSession -> {
            try {
                if (rollbackingSession.getStatus() == GlobalStatus.Rollbacking && !rollbackingSession.isDeadSession()) {
                    return;
                }
                if (this.isRetryTimeout(now, MAX_ROLLBACK_RETRY_TIMEOUT, rollbackingSession.getBeginTime())) {
                    if (ROLLBACK_RETRY_TIMEOUT_UNLOCK_ENABLE) {
                        rollbackingSession.clean();
                    }
                    SessionHelper.endRollbackFailed(rollbackingSession, true, true);
                    return;
                }
                rollbackingSession.addSessionLifecycleListener(SessionHolder.getRootSessionManager());
                this.core.doGlobalRollback(rollbackingSession, true);
            }
            catch (TransactionException ex) {
                LOGGER.error("Failed to retry rollbacking [{}] {} {}", new Object[]{rollbackingSession.getXid(), ex.getCode(), ex.getMessage()});
            }
        });
    }

    protected void handleRetryCommitting() {
        SessionCondition retryCommittingSessionCondition = new SessionCondition(this.retryCommittingStatuses);
        retryCommittingSessionCondition.setLazyLoadBranch(true);
        List<GlobalSession> committingSessions = SessionHolder.getRetryCommittingSessionManager().findGlobalSessions(retryCommittingSessionCondition);
        if (CollectionUtils.isEmpty(committingSessions)) {
            return;
        }
        long now = System.currentTimeMillis();
        SessionHelper.forEach(committingSessions, committingSession -> {
            try {
                if (GlobalStatus.Committing.equals((Object)committingSession.getStatus()) && !committingSession.isDeadSession()) {
                    return;
                }
                if (this.isRetryTimeout(now, MAX_COMMIT_RETRY_TIMEOUT, committingSession.getBeginTime())) {
                    SessionHelper.endCommitFailed(committingSession, true, true);
                    return;
                }
                if (GlobalStatus.Committed.equals((Object)committingSession.getStatus()) && committingSession.getBranchSessions().isEmpty()) {
                    SessionHelper.endCommitted(committingSession, true);
                }
                committingSession.addSessionLifecycleListener(SessionHolder.getRootSessionManager());
                this.core.doGlobalCommit(committingSession, true);
            }
            catch (TransactionException ex) {
                LOGGER.error("Failed to retry committing [{}] {} {}", new Object[]{committingSession.getXid(), ex.getCode(), ex.getMessage()});
            }
        });
    }

    protected void handleAsyncCommitting() {
        SessionCondition sessionCondition = new SessionCondition(GlobalStatus.AsyncCommitting);
        List<GlobalSession> asyncCommittingSessions = SessionHolder.getAsyncCommittingSessionManager().findGlobalSessions(sessionCondition);
        if (CollectionUtils.isEmpty(asyncCommittingSessions)) {
            return;
        }
        SessionHelper.forEach(asyncCommittingSessions, asyncCommittingSession -> {
            try {
                asyncCommittingSession.addSessionLifecycleListener(SessionHolder.getRootSessionManager());
                this.core.doGlobalCommit(asyncCommittingSession, true);
            }
            catch (TransactionException ex) {
                LOGGER.error("Failed to async committing [{}] {} {}", new Object[]{asyncCommittingSession.getXid(), ex.getCode(), ex.getMessage(), ex});
            }
        });
    }

    protected void undoLogDelete() {
        Map rmChannels = ChannelManager.getRmChannels();
        if (rmChannels == null || rmChannels.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("no active rm channels to delete undo log");
            }
            return;
        }
        short saveDays = CONFIG.getShort("server.undo.logSaveDays", (short)7);
        for (Map.Entry channelEntry : rmChannels.entrySet()) {
            String resourceId = (String)channelEntry.getKey();
            UndoLogDeleteRequest deleteRequest = new UndoLogDeleteRequest();
            deleteRequest.setResourceId(resourceId);
            deleteRequest.setSaveDays(saveDays > 0 ? saveDays : (short)7);
            try {
                this.remotingServer.sendAsyncRequest((Channel)channelEntry.getValue(), (Object)deleteRequest);
            }
            catch (Exception e) {
                LOGGER.error("Failed to async delete undo log resourceId = {}, exception: {}", (Object)resourceId, (Object)e.getMessage());
            }
        }
    }

    private boolean isRetryTimeout(long now, long timeout, long beginTime) {
        return timeout >= 0L && now - beginTime > timeout;
    }

    public void init() {
        this.retryRollbacking.scheduleAtFixedRate(() -> SessionHolder.distributedLockAndExecute("RetryRollbacking", this::handleRetryRollbacking), 0L, ROLLBACKING_RETRY_PERIOD, TimeUnit.MILLISECONDS);
        this.retryCommitting.scheduleAtFixedRate(() -> SessionHolder.distributedLockAndExecute("RetryCommitting", this::handleRetryCommitting), 0L, COMMITTING_RETRY_PERIOD, TimeUnit.MILLISECONDS);
        this.asyncCommitting.scheduleAtFixedRate(() -> SessionHolder.distributedLockAndExecute("AsyncCommitting", this::handleAsyncCommitting), 0L, ASYNC_COMMITTING_RETRY_PERIOD, TimeUnit.MILLISECONDS);
        this.timeoutCheck.scheduleAtFixedRate(() -> SessionHolder.distributedLockAndExecute("TxTimeoutCheck", this::timeoutCheck), 0L, TIMEOUT_RETRY_PERIOD, TimeUnit.MILLISECONDS);
        this.undoLogDelete.scheduleAtFixedRate(() -> SessionHolder.distributedLockAndExecute("UndologDelete", this::undoLogDelete), 180000L, UNDO_LOG_DELETE_PERIOD, TimeUnit.MILLISECONDS);
    }

    public AbstractResultMessage onRequest(AbstractMessage request, RpcContext context) {
        if (!(request instanceof AbstractTransactionRequestToTC)) {
            throw new IllegalArgumentException();
        }
        AbstractTransactionRequestToTC transactionRequest = (AbstractTransactionRequestToTC)request;
        transactionRequest.setTCInboundHandler((TCInboundHandler)this);
        return transactionRequest.handle(context);
    }

    public void onResponse(AbstractResultMessage response, RpcContext context) {
        if (!(response instanceof AbstractTransactionResponse)) {
            throw new IllegalArgumentException();
        }
    }

    public void destroy() {
        this.retryRollbacking.shutdown();
        this.retryCommitting.shutdown();
        this.asyncCommitting.shutdown();
        this.timeoutCheck.shutdown();
        this.undoLogDelete.shutdown();
        if (this.branchRemoveExecutor != null) {
            this.branchRemoveExecutor.shutdown();
        }
        try {
            this.retryRollbacking.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            this.retryCommitting.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            this.asyncCommitting.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            this.timeoutCheck.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            this.undoLogDelete.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            if (this.branchRemoveExecutor != null) {
                this.branchRemoveExecutor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.remotingServer instanceof NettyRemotingServer) {
            ((NettyRemotingServer)this.remotingServer).destroy();
        }
        SessionHolder.destroy();
        instance = null;
    }

    public void setRemotingServer(RemotingServer remotingServer) {
        this.remotingServer = remotingServer;
    }

    static class BranchRemoveTask
    implements Runnable {
        private final GlobalSession globalSession;
        private final BranchSession branchSession;

        public BranchRemoveTask(GlobalSession globalSession, BranchSession branchSession) {
            this.globalSession = globalSession;
            if (branchSession == null) {
                throw new IllegalArgumentException("BranchSession can`t be null!");
            }
            this.branchSession = branchSession;
        }

        public BranchRemoveTask(GlobalSession globalSession) {
            this.globalSession = globalSession;
            this.branchSession = null;
        }

        @Override
        public void run() {
            if (this.globalSession == null) {
                return;
            }
            try {
                MDC.put((String)"X-TX-XID", (String)this.globalSession.getXid());
                if (this.branchSession != null) {
                    this.doRemove(this.branchSession);
                } else {
                    this.globalSession.getSortedBranches().forEach(this::doRemove);
                }
            }
            catch (Exception unKnowException) {
                LOGGER.error("Asynchronous delete branchSession error, xid = {}", (Object)this.globalSession.getXid(), (Object)unKnowException);
            }
            finally {
                MDC.remove((String)"X-TX-XID");
            }
        }

        private void doRemove(BranchSession bt) {
            try {
                MDC.put((String)"X-TX-BRANCH-ID", (String)String.valueOf(bt.getBranchId()));
                this.globalSession.removeBranch(bt);
                LOGGER.info("Asynchronous delete branchSession successfully, xid = {}, branchId = {}", (Object)this.globalSession.getXid(), (Object)bt.getBranchId());
            }
            catch (TransactionException transactionException) {
                LOGGER.error("Asynchronous delete branchSession error, xid = {}, branchId = {}", new Object[]{this.globalSession.getXid(), bt.getBranchId(), transactionException});
            }
            finally {
                MDC.remove((String)"X-TX-BRANCH-ID");
            }
        }
    }
}

