/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.console.impl.redis;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.util.BeanUtils;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.console.param.BaseParam;
import io.seata.console.result.PageResult;
import io.seata.server.console.param.GlobalLockParam;
import io.seata.server.console.service.GlobalLockService;
import io.seata.server.console.vo.GlobalLockVO;
import io.seata.server.storage.redis.JedisPooledFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;

@Component
@Configuration
@ConditionalOnExpression(value="#{'redis'.equals('${lockMode}')}")
public class GlobalLockRedisServiceImpl
implements GlobalLockService {
    @Override
    public PageResult<GlobalLockVO> query(GlobalLockParam param) {
        int total = 0;
        PageResult.checkPage((BaseParam)param);
        if (StringUtils.isNotBlank((String)param.getXid())) {
            List<GlobalLockVO> globalLockVos = this.queryGlobalByXid(param.getXid());
            total = globalLockVos.size();
            return PageResult.success(globalLockVos, (Integer)total, (Integer)param.getPageNum(), (Integer)param.getPageSize());
        }
        if (StringUtils.isNotBlank((String)param.getTableName()) && StringUtils.isNotBlank((String)param.getPk()) && StringUtils.isNotBlank((String)param.getResourceId())) {
            String tableName = param.getTableName();
            String pk = param.getPk();
            String resourceId = param.getResourceId();
            List<GlobalLockVO> globalLockVos = this.queryGlobalLockByRowKey(this.buildRowKey(tableName, pk, resourceId));
            total = globalLockVos.size();
            return PageResult.success(globalLockVos, (Integer)total, (Integer)param.getPageNum(), (Integer)param.getPageSize());
        }
        return PageResult.failure((String)FrameworkErrorCode.ParameterRequired.getErrCode(), (String)"only three parameters of tableName,pk,resourceId or Xid are supported");
    }

    private List<GlobalLockVO> queryGlobalLockByRowKey(String buildRowKey) {
        return this.readGlobalLockByRowKey(buildRowKey);
    }

    private String buildRowKey(String tableName, String pk, String resourceId) {
        return "SEATA_ROW_LOCK_" + resourceId + "^^^" + tableName + "^^^" + pk;
    }

    private List<GlobalLockVO> queryGlobalByXid(String xid) {
        return this.readGlobalLockByXid("SEATA_GLOBAL_LOCK" + xid);
    }

    private List<GlobalLockVO> readGlobalLockByXid(String key) {
        ArrayList<GlobalLockVO> vos = new ArrayList<GlobalLockVO>();
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            Map mapGlobalKeys = jedis.hgetAll(key);
            if (CollectionUtils.isNotEmpty((Map)mapGlobalKeys)) {
                ArrayList rowLockKeys = new ArrayList();
                mapGlobalKeys.forEach((k, v) -> rowLockKeys.addAll(Arrays.asList(v.split(";"))));
                for (String rowLoclKey : rowLockKeys) {
                    Map mapRowLockKey = jedis.hgetAll(rowLoclKey);
                    GlobalLockVO vo = (GlobalLockVO)BeanUtils.mapToObject((Map)mapRowLockKey, GlobalLockVO.class);
                    if (vo == null) continue;
                    vos.add(vo);
                }
            }
        }
        return vos;
    }

    private List<GlobalLockVO> readGlobalLockByRowKey(String key) {
        ArrayList<GlobalLockVO> vos = new ArrayList<GlobalLockVO>();
        try (Jedis jedis = JedisPooledFactory.getJedisInstance();){
            Map map = jedis.hgetAll(key);
            GlobalLockVO vo = (GlobalLockVO)BeanUtils.mapToObject((Map)map, GlobalLockVO.class);
            if (vo != null) {
                vos.add(vo);
            }
        }
        return vos;
    }
}

