/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.console.impl.db;

import io.seata.common.exception.StoreException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.IOUtil;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.console.result.PageResult;
import io.seata.core.store.db.DataSourceProvider;
import io.seata.core.store.db.sql.log.LogStoreSqlsFactory;
import io.seata.server.console.service.BranchSessionService;
import io.seata.server.console.vo.BranchSessionVO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConditionalOnExpression(value="#{'db'.equals('${sessionMode}')}")
public class BranchSessionDBServiceImpl
implements BranchSessionService {
    private String branchTable;
    private String dbType;
    private DataSource dataSource;

    public BranchSessionDBServiceImpl() {
        io.seata.config.Configuration configuration = ConfigurationFactory.getInstance();
        this.branchTable = configuration.getConfig("store.db.branchTable", "branch_table");
        this.dbType = configuration.getConfig("store.db.dbType");
        if (StringUtils.isBlank((String)this.dbType)) {
            throw new IllegalArgumentException("store.db.dbType should not be blank");
        }
        String dbDataSource = configuration.getConfig("store.db.datasource");
        if (StringUtils.isBlank((String)dbDataSource)) {
            throw new IllegalArgumentException("store.db.datasource should not be blank");
        }
        this.dataSource = ((DataSourceProvider)EnhancedServiceLoader.load(DataSourceProvider.class, (String)dbDataSource)).provide();
    }

    @Override
    public PageResult<BranchSessionVO> queryByXid(String xid) {
        if (StringUtils.isBlank((String)xid)) {
            throw new IllegalArgumentException("xid should not be blank");
        }
        String whereCondition = " where xid = ? ";
        String branchSessionSQL = LogStoreSqlsFactory.getLogStoreSqls((String)this.dbType).getAllBranchSessionSQL(this.branchTable, whereCondition);
        ArrayList<BranchSessionVO> list = new ArrayList<BranchSessionVO>();
        ResultSet rs = null;
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(branchSessionSQL);){
            ps.setObject(1, xid);
            rs = ps.executeQuery();
            while (rs.next()) {
                list.add(BranchSessionVO.convert(rs));
            }
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(rs);
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable)rs);
        return PageResult.success(list, (Integer)list.size(), (Integer)0, (Integer)0, (Integer)0);
    }
}

