/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo;

import io.seata.common.exception.NotSupportYetException;
import io.seata.rm.datasource.undo.UndoLogManager;
import io.seata.rm.datasource.undo.mysql.MySQLUndoLogManager;
import io.seata.rm.datasource.undo.oracle.OracleUndoLogManager;
import java.util.HashMap;
import java.util.Map;

public final class UndoLogManagerFactory {
    private static final Map<String, UndoLogManager> UNDO_LOG_MANAGER_MAP = new HashMap<String, UndoLogManager>();

    private UndoLogManagerFactory() {
    }

    public static UndoLogManager getUndoLogManager(String dbType) {
        UndoLogManager undoLogManager = UNDO_LOG_MANAGER_MAP.get(dbType);
        if (undoLogManager == null) {
            throw new NotSupportYetException("not support dbType[" + dbType + "]");
        }
        return undoLogManager;
    }

    static {
        UNDO_LOG_MANAGER_MAP.put("mysql", new MySQLUndoLogManager());
        UNDO_LOG_MANAGER_MAP.put("oracle", new OracleUndoLogManager());
    }
}

