/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql.struct;

import com.alibaba.druid.util.StringUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.core.context.RootContext;
import io.seata.rm.datasource.AbstractConnectionProxy;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.rm.datasource.sql.struct.ColumnMeta;
import io.seata.rm.datasource.sql.struct.IndexMeta;
import io.seata.rm.datasource.sql.struct.IndexType;
import io.seata.rm.datasource.sql.struct.TableMeta;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class TableMetaCache {
    private static final long CACHE_SIZE = 100000L;
    private static final long EXPIRE_TIME = 900000L;
    private static final Cache<String, TableMeta> TABLE_META_CACHE = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterWrite(900000L, TimeUnit.MILLISECONDS).softValues().build();

    public static TableMeta getTableMeta(final DataSourceProxy dataSourceProxy, final String tableName) {
        if (StringUtils.isEmpty((String)tableName)) {
            throw new IllegalArgumentException("TableMeta cannot be fetched without tableName");
        }
        String dataSourceKey = dataSourceProxy.getResourceId();
        TableMeta tmeta = null;
        String key = dataSourceKey + "." + tableName;
        try {
            tmeta = (TableMeta)TABLE_META_CACHE.get((Object)key, (Callable)new Callable<TableMeta>(){

                @Override
                public TableMeta call() throws Exception {
                    return TableMetaCache.fetchSchema(dataSourceProxy.getTargetDataSource(), tableName);
                }
            });
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        if (tmeta == null) {
            try {
                tmeta = TableMetaCache.fetchSchema(dataSourceProxy.getTargetDataSource(), tableName);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (tmeta == null) {
            throw new ShouldNeverHappenException(String.format("[xid:%s]get tablemeta failed", RootContext.getXID()));
        }
        return tmeta;
    }

    private static TableMeta fetchSchema(DataSource dataSource, String tableName) throws SQLException {
        return TableMetaCache.fetchSchemeInDefaultWay(dataSource, tableName);
    }

    private static TableMeta fetchSchemeInDefaultWay(DataSource dataSource, String tableName) throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = dataSource.getConnection();
            stmt = conn.createStatement();
            StringBuffer sb = new StringBuffer("SELECT * FROM " + tableName + " LIMIT 1");
            rs = stmt.executeQuery(sb.toString());
            ResultSetMetaData rsmd = rs.getMetaData();
            DatabaseMetaData dbmd = conn.getMetaData();
            TableMeta tableMeta = TableMetaCache.resultSetMetaToSchema(rsmd, dbmd, tableName);
            return tableMeta;
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException("Failed to fetch schema of " + tableName, e);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TableMeta resultSetMetaToSchema(ResultSet rs2, AbstractConnectionProxy conn, String tablename) throws SQLException {
        String tableName = tablename;
        TableMeta tm = new TableMeta();
        tm.setTableName(tableName);
        while (rs2.next()) {
            ColumnMeta col = new ColumnMeta();
            col.setTableName(tableName);
            col.setColumnName(rs2.getString("COLUMN_NAME"));
            String datatype = rs2.getString("DATA_TYPE");
            if (StringUtils.equalsIgnoreCase((String)datatype, (String)"NUMBER")) {
                col.setDataType(-5);
            } else if (StringUtils.equalsIgnoreCase((String)datatype, (String)"VARCHAR2")) {
                col.setDataType(12);
            } else if (StringUtils.equalsIgnoreCase((String)datatype, (String)"CHAR")) {
                col.setDataType(1);
            } else if (StringUtils.equalsIgnoreCase((String)datatype, (String)"DATE")) {
                col.setDataType(91);
            }
            col.setColumnSize(rs2.getInt("DATA_LENGTH"));
            tm.getAllColumns().put(col.getColumnName(), col);
        }
        Statement stmt = null;
        ResultSet rs1 = null;
        try {
            stmt = conn.getTargetConnection().createStatement();
            rs1 = stmt.executeQuery("select a.constraint_name,  a.column_name from user_cons_columns a, user_constraints b  where a.constraint_name = b.constraint_name and b.constraint_type = 'P' and a.table_name ='" + tableName + "'");
            while (rs1.next()) {
                IndexMeta index;
                String indexName = rs1.getString(1);
                String colName = rs1.getString(2);
                ColumnMeta col = tm.getAllColumns().get(colName);
                if (tm.getAllIndexes().containsKey(indexName)) {
                    index = tm.getAllIndexes().get(indexName);
                    index.getValues().add(col);
                    continue;
                }
                index = new IndexMeta();
                index.setIndexName(indexName);
                index.getValues().add(col);
                index.setIndextype(IndexType.PRIMARY);
                tm.getAllIndexes().put(indexName, index);
            }
        }
        finally {
            if (rs1 != null) {
                rs1.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return tm;
    }

    private static TableMeta resultSetMetaToSchema(ResultSetMetaData rsmd, DatabaseMetaData dbmd, String tableName) throws SQLException {
        String schemaName = rsmd.getSchemaName(1);
        String catalogName = rsmd.getCatalogName(1);
        TableMeta tm = new TableMeta();
        tm.setTableName(tableName);
        ResultSet rs1 = dbmd.getColumns(catalogName, schemaName, tableName, "%");
        while (rs1.next()) {
            ColumnMeta col = new ColumnMeta();
            col.setTableCat(rs1.getString("TABLE_CAT"));
            col.setTableSchemaName(rs1.getString("TABLE_SCHEM"));
            col.setTableName(rs1.getString("TABLE_NAME"));
            col.setColumnName(rs1.getString("COLUMN_NAME"));
            col.setDataType(rs1.getInt("DATA_TYPE"));
            col.setDataTypeName(rs1.getString("TYPE_NAME"));
            col.setColumnSize(rs1.getInt("COLUMN_SIZE"));
            col.setDecimalDigits(rs1.getInt("DECIMAL_DIGITS"));
            col.setNumPrecRadix(rs1.getInt("NUM_PREC_RADIX"));
            col.setNullAble(rs1.getInt("NULLABLE"));
            col.setRemarks(rs1.getString("REMARKS"));
            col.setColumnDef(rs1.getString("COLUMN_DEF"));
            col.setSqlDataType(rs1.getInt("SQL_DATA_TYPE"));
            col.setSqlDatetimeSub(rs1.getInt("SQL_DATETIME_SUB"));
            col.setCharOctetLength(rs1.getInt("CHAR_OCTET_LENGTH"));
            col.setOrdinalPosition(rs1.getInt("ORDINAL_POSITION"));
            col.setIsNullAble(rs1.getString("IS_NULLABLE"));
            col.setIsAutoincrement(rs1.getString("IS_AUTOINCREMENT"));
            tm.getAllColumns().put(col.getColumnName(), col);
        }
        ResultSet rs2 = dbmd.getIndexInfo(catalogName, schemaName, tableName, false, true);
        String indexName = "";
        while (rs2.next()) {
            IndexMeta index;
            indexName = rs2.getString("INDEX_NAME");
            String colName = rs2.getString("COLUMN_NAME");
            ColumnMeta col = tm.getAllColumns().get(colName);
            if (tm.getAllIndexes().containsKey(indexName)) {
                index = tm.getAllIndexes().get(indexName);
                index.getValues().add(col);
                continue;
            }
            index = new IndexMeta();
            index.setIndexName(indexName);
            index.setNonUnique(rs2.getBoolean("NON_UNIQUE"));
            index.setIndexQualifier(rs2.getString("INDEX_QUALIFIER"));
            index.setIndexName(rs2.getString("INDEX_NAME"));
            index.setType(rs2.getShort("TYPE"));
            index.setOrdinalPosition(rs2.getShort("ORDINAL_POSITION"));
            index.setAscOrDesc(rs2.getString("ASC_OR_DESC"));
            index.setCardinality(rs2.getInt("CARDINALITY"));
            index.getValues().add(col);
            if ("PRIMARY".equalsIgnoreCase(indexName) || indexName.equalsIgnoreCase(rsmd.getTableName(1) + "_pkey")) {
                index.setIndextype(IndexType.PRIMARY);
            } else if (!index.isNonUnique()) {
                index.setIndextype(IndexType.Unique);
            } else {
                index.setIndextype(IndexType.Normal);
            }
            tm.getAllIndexes().put(indexName, index);
        }
        IndexMeta index = tm.getAllIndexes().get(indexName);
        if (index.getIndextype().value() != 0) {
            if ("H2 JDBC Driver".equals(dbmd.getDriverName())) {
                if (indexName.length() > 11 && "PRIMARY_KEY".equalsIgnoreCase(indexName.substring(0, 11))) {
                    index.setIndextype(IndexType.PRIMARY);
                }
            } else if (dbmd.getDriverName() != null && dbmd.getDriverName().toLowerCase().indexOf("postgresql") >= 0 && (tableName + "_pkey").equalsIgnoreCase(indexName)) {
                index.setIndextype(IndexType.PRIMARY);
            }
        }
        return tm;
    }
}

