/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.store.db;

import io.seata.common.exception.NotSupportYetException;
import io.seata.core.constants.DBType;

public class LockStoreSqls {
    public static final String LOCK_TABLE_PLACEHOLD = " #lock_table# ";
    public static final String IN_PARAMS_PLACEHOLD = " #in_params# ";
    public static final String ALL_COLUMNS = "xid, transaction_id, branch_id, resource_id, table_name, pk, row_key, gmt_create, gmt_modified";
    public static final String INSERT_LOCK_SQL_MYSQL = "insert into  #lock_table# (xid, transaction_id, branch_id, resource_id, table_name, pk, row_key, gmt_create, gmt_modified)values (?, ?, ?, ?, ?, ?, ?, now(), now())";
    public static final String INSERT_LOCK_SQL_ORACLE = "insert into  #lock_table# (xid, transaction_id, branch_id, resource_id, table_name, pk, row_key, gmt_create, gmt_modified)values (?, ?, ?, ?, ?, ?, ?, sysdate, sysdate)";
    public static final String DELETE_LOCK_SQL = "delete from  #lock_table#  where row_key = ? and xid = ?";
    public static final String BATCH_DELETE_LOCK_SQL = "delete from  #lock_table#  where xid = ? and row_key in ( #in_params# ) ";
    public static final String BATCH_DELETE_LOCK_BY_BRANCH_SQL = "delete from  #lock_table#  where xid = ? and branch_id = ? ";
    public static final String BATCH_DELETE_LOCK_BY_BRANCHS_SQL = "delete from  #lock_table#  where xid = ? and branch_id in ( #in_params# ) ";
    public static final String QUERY_LOCK_SQL = "select xid, transaction_id, branch_id, resource_id, table_name, pk, row_key, gmt_create, gmt_modified from  #lock_table#  where row_key = ? ";
    public static final String CHECK_LOCK_SQL = "select xid, transaction_id, branch_id, resource_id, table_name, pk, row_key, gmt_create, gmt_modified from  #lock_table#  where row_key in ( #in_params# )";

    public static String getInsertLockSQL(String lockTable, String dbType) {
        if (DBType.MYSQL.name().equalsIgnoreCase(dbType) || DBType.OCEANBASE.name().equalsIgnoreCase(dbType) || DBType.H2.name().equalsIgnoreCase(dbType)) {
            return INSERT_LOCK_SQL_MYSQL.replace(LOCK_TABLE_PLACEHOLD, lockTable);
        }
        if (DBType.ORACLE.name().equalsIgnoreCase(dbType)) {
            return INSERT_LOCK_SQL_ORACLE.replace(LOCK_TABLE_PLACEHOLD, lockTable);
        }
        throw new NotSupportYetException("unknown dbType:" + dbType);
    }

    public static String getDeleteLockSql(String lockTable, String dbType) {
        return DELETE_LOCK_SQL.replace(LOCK_TABLE_PLACEHOLD, lockTable);
    }

    public static String getBatchDeleteLockSql(String lockTable, String paramPlaceHold, String dbType) {
        return BATCH_DELETE_LOCK_SQL.replace(LOCK_TABLE_PLACEHOLD, lockTable).replace(IN_PARAMS_PLACEHOLD, paramPlaceHold);
    }

    public static String getBatchDeleteLockSqlByBranch(String lockTable, String dbType) {
        return BATCH_DELETE_LOCK_BY_BRANCH_SQL.replace(LOCK_TABLE_PLACEHOLD, lockTable);
    }

    public static String getBatchDeleteLockSqlByBranchs(String lockTable, String paramPlaceHold, String dbType) {
        return BATCH_DELETE_LOCK_BY_BRANCHS_SQL.replace(LOCK_TABLE_PLACEHOLD, lockTable).replace(IN_PARAMS_PLACEHOLD, paramPlaceHold);
    }

    public static String getQueryLockSql(String lockTable, String dbType) {
        return QUERY_LOCK_SQL.replace(LOCK_TABLE_PLACEHOLD, lockTable);
    }

    public static String getCheckLockableSql(String lockTable, String paramPlaceHold, String dbType) {
        return CHECK_LOCK_SQL.replace(LOCK_TABLE_PLACEHOLD, lockTable).replace(IN_PARAMS_PLACEHOLD, paramPlaceHold);
    }
}

