/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.store.db;

import io.seata.common.exception.DataAccessException;
import io.seata.common.exception.StoreException;
import io.seata.common.executor.Initialize;
import io.seata.common.loader.LoadLevel;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.IOUtil;
import io.seata.common.util.LambdaUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.core.store.LockDO;
import io.seata.core.store.LockStore;
import io.seata.core.store.db.LockStoreSqls;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="db")
public class LockStoreDataBaseDAO
implements LockStore,
Initialize {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockStoreDataBaseDAO.class);
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();
    protected DataSource logStoreDataSource = null;
    protected String lockTable;
    protected String dbType;

    public LockStoreDataBaseDAO(DataSource logStoreDataSource) {
        this.logStoreDataSource = logStoreDataSource;
    }

    public void init() {
        this.lockTable = CONFIG.getConfig("store.db.lock-table", "lock_table");
        this.dbType = CONFIG.getConfig("store.db.db-type");
        if (StringUtils.isBlank((String)this.dbType)) {
            throw new StoreException("there must be db type.");
        }
        if (this.logStoreDataSource == null) {
            throw new StoreException("there must be logStoreDataSource.");
        }
    }

    @Override
    public boolean acquireLock(LockDO lockDO) {
        return this.acquireLock(Collections.singletonList(lockDO));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public boolean acquireLock(List<LockDO> lockDOs) {
        block44: {
            block43: {
                block42: {
                    block41: {
                        conn = null;
                        ps = null;
                        rs = null;
                        dbExistedRowKeys = new HashSet<String>();
                        originalAutoCommit = true;
                        if (lockDOs.size() > 1) {
                            lockDOs = lockDOs.stream().filter(LambdaUtils.distinctByKey((Function<LockDO, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getRowKey(), (Lio/seata/core/store/LockDO;)Ljava/lang/Object;)())).collect(Collectors.toList());
                        }
                        conn = this.logStoreDataSource.getConnection();
                        originalAutoCommit = conn.getAutoCommit();
                        if (originalAutoCommit) {
                            conn.setAutoCommit(false);
                        }
                        sj = new StringJoiner(",");
                        for (i = 0; i < lockDOs.size(); ++i) {
                            sj.add("?");
                        }
                        canLock = true;
                        checkLockSQL = LockStoreSqls.getCheckLockableSql(this.lockTable, sj.toString(), this.dbType);
                        ps = conn.prepareStatement(checkLockSQL);
                        for (i = 0; i < lockDOs.size(); ++i) {
                            ps.setString(i + 1, lockDOs.get(i).getRowKey());
                        }
                        rs = ps.executeQuery();
                        currentXID = lockDOs.get(0).getXid();
                        while (rs.next()) {
                            dbXID = rs.getString("xid");
                            if (!StringUtils.equals((String)dbXID, (String)currentXID)) {
                                if (LockStoreDataBaseDAO.LOGGER.isInfoEnabled()) {
                                    dbPk = rs.getString("pk");
                                    dbTableName = rs.getString("table_name");
                                    dbBranchId = rs.getLong("branch_id");
                                    LockStoreDataBaseDAO.LOGGER.info("Global lock on [{}:{}] is holding by xid {} branchId {}", new Object[]{dbTableName, dbPk, dbXID, dbBranchId});
                                }
                                canLock &= false;
                                break;
                            }
                            dbExistedRowKeys.add(rs.getString("row_key"));
                        }
                        if (canLock) break block41;
                        conn.rollback();
                        dbXID = false;
                        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
                        if (conn != null) {
                            try {
                                if (originalAutoCommit) {
                                    conn.setAutoCommit(true);
                                }
                                conn.close();
                            }
                            catch (SQLException dbPk) {
                                // empty catch block
                            }
                        }
                        return dbXID;
                    }
                    unrepeatedLockDOs /* !! */  = null;
                    unrepeatedLockDOs /* !! */  = CollectionUtils.isNotEmpty(dbExistedRowKeys) != false ? lockDOs.stream().filter((Predicate<LockDO>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$acquireLock$0(java.util.Set io.seata.core.store.LockDO ), (Lio/seata/core/store/LockDO;)Z)(dbExistedRowKeys)).collect(Collectors.toList()) : lockDOs;
                    if (!CollectionUtils.isEmpty(unrepeatedLockDOs /* !! */ )) break block42;
                    conn.rollback();
                    dbPk = true;
                    IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
                    if (conn != null) {
                        try {
                            if (originalAutoCommit) {
                                conn.setAutoCommit(true);
                            }
                            conn.close();
                        }
                        catch (SQLException var13_21) {
                            // empty catch block
                        }
                    }
                    return dbPk;
                }
                if (unrepeatedLockDOs /* !! */ .size() != 1) ** GOTO lbl91
                lockDO = unrepeatedLockDOs /* !! */ .get(0);
                if (this.doAcquireLock(conn, lockDO)) break block43;
                if (LockStoreDataBaseDAO.LOGGER.isInfoEnabled()) {
                    LockStoreDataBaseDAO.LOGGER.info("Global lock acquire failed, xid {} branchId {} pk {}", new Object[]{lockDO.getXid(), lockDO.getBranchId(), lockDO.getPk()});
                }
                conn.rollback();
                var13_22 = false;
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
                if (conn != null) {
                    try {
                        if (originalAutoCommit) {
                            conn.setAutoCommit(true);
                        }
                        conn.close();
                    }
                    catch (SQLException var14_26) {
                        // empty catch block
                    }
                }
                return var13_22;
            }
            break block44;
lbl91:
            // 1 sources

            if (this.doAcquireLocks(conn, unrepeatedLockDOs /* !! */ )) break block44;
            if (LockStoreDataBaseDAO.LOGGER.isInfoEnabled()) {
                LockStoreDataBaseDAO.LOGGER.info("Global lock batch acquire failed, xid {} branchId {} pks {}", new Object[]{unrepeatedLockDOs /* !! */ .get(0).getXid(), unrepeatedLockDOs /* !! */ .get(0).getBranchId(), unrepeatedLockDOs /* !! */ .stream().map((Function<LockDO, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$acquireLock$1(io.seata.core.store.LockDO ), (Lio/seata/core/store/LockDO;)Ljava/lang/String;)()).collect(Collectors.toList())});
            }
            conn.rollback();
            var12_18 = false;
            IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
            if (conn != null) {
                try {
                    if (originalAutoCommit) {
                        conn.setAutoCommit(true);
                    }
                    conn.close();
                }
                catch (SQLException var13_23) {
                    // empty catch block
                }
            }
            return var12_18;
        }
        try {
            conn.commit();
            var12_19 = true;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable var15_27) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
                if (conn != null) {
                    try {
                        if (originalAutoCommit) {
                            conn.setAutoCommit(true);
                        }
                        conn.close();
                    }
                    catch (SQLException var16_28) {
                        // empty catch block
                    }
                }
                throw var15_27;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
        if (conn != null) {
            try {
                if (originalAutoCommit) {
                    conn.setAutoCommit(true);
                }
                conn.close();
            }
            catch (SQLException var13_24) {
                // empty catch block
            }
        }
        return var12_19;
    }

    @Override
    public boolean unLock(LockDO lockDO) {
        return this.unLock(Collections.singletonList(lockDO));
    }

    @Override
    public boolean unLock(List<LockDO> lockDOs) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            StringJoiner sj = new StringJoiner(",");
            for (int i = 0; i < lockDOs.size(); ++i) {
                sj.add("?");
            }
            String batchDeleteSQL = LockStoreSqls.getBatchDeleteLockSql(this.lockTable, sj.toString(), this.dbType);
            ps = conn.prepareStatement(batchDeleteSQL);
            ps.setString(1, lockDOs.get(0).getXid());
            for (int i = 0; i < lockDOs.size(); ++i) {
                ps.setString(i + 2, lockDOs.get(i).getRowKey());
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return true;
    }

    @Override
    public boolean unLock(String xid, Long branchId) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            String batchDeleteSQL = LockStoreSqls.getBatchDeleteLockSqlByBranch(this.lockTable, this.dbType);
            ps = conn.prepareStatement(batchDeleteSQL);
            ps.setString(1, xid);
            ps.setLong(2, branchId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return true;
    }

    @Override
    public boolean unLock(String xid, List<Long> branchIds) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            StringJoiner sj = new StringJoiner(",");
            branchIds.stream().forEach(branchId -> sj.add("?"));
            String batchDeleteSQL = LockStoreSqls.getBatchDeleteLockSqlByBranchs(this.lockTable, sj.toString(), this.dbType);
            ps = conn.prepareStatement(batchDeleteSQL);
            ps.setString(1, xid);
            for (int i = 0; i < branchIds.size(); ++i) {
                ps.setLong(i + 2, branchIds.get(i));
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{ps, conn});
        return true;
    }

    @Override
    public boolean isLockable(List<LockDO> lockDOs) {
        Connection conn = null;
        try {
            conn = this.logStoreDataSource.getConnection();
            conn.setAutoCommit(true);
            if (!this.checkLockable(conn, lockDOs)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw new DataAccessException((Throwable)e);
        }
        finally {
            IOUtil.close((AutoCloseable)conn);
        }
    }

    protected boolean doAcquireLock(Connection conn, LockDO lockDO) {
        boolean bl;
        PreparedStatement ps = null;
        try {
            String insertLockSQL = LockStoreSqls.getInsertLockSQL(this.lockTable, this.dbType);
            ps = conn.prepareStatement(insertLockSQL);
            ps.setString(1, lockDO.getXid());
            ps.setLong(2, lockDO.getTransactionId());
            ps.setLong(3, lockDO.getBranchId());
            ps.setString(4, lockDO.getResourceId());
            ps.setString(5, lockDO.getTableName());
            ps.setString(6, lockDO.getPk());
            ps.setString(7, lockDO.getRowKey());
            bl = ps.executeUpdate() > 0;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(ps);
                throw throwable;
            }
        }
        IOUtil.close((AutoCloseable)ps);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doAcquireLocks(Connection conn, List<LockDO> lockDOs) {
        boolean bl;
        PreparedStatement ps = null;
        try {
            String insertLockSQL = LockStoreSqls.getInsertLockSQL(this.lockTable, this.dbType);
            ps = conn.prepareStatement(insertLockSQL);
            for (LockDO lockDO : lockDOs) {
                ps.setString(1, lockDO.getXid());
                ps.setLong(2, lockDO.getTransactionId());
                ps.setLong(3, lockDO.getBranchId());
                ps.setString(4, lockDO.getResourceId());
                ps.setString(5, lockDO.getTableName());
                ps.setString(6, lockDO.getPk());
                ps.setString(7, lockDO.getRowKey());
                ps.addBatch();
            }
            bl = ps.executeBatch().length == lockDOs.size();
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                LOGGER.error("Global lock batch acquire error: {}", (Object)e.getMessage(), (Object)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtil.close(ps);
                throw throwable;
            }
            IOUtil.close((AutoCloseable)ps);
            return bl2;
        }
        IOUtil.close((AutoCloseable)ps);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkLockable(Connection conn, List<LockDO> lockDOs) {
        boolean bl;
        ResultSet rs;
        PreparedStatement ps;
        block8: {
            boolean bl2;
            ps = null;
            rs = null;
            try {
                StringJoiner sj = new StringJoiner(",");
                for (int i = 0; i < lockDOs.size(); ++i) {
                    sj.add("?");
                }
                String checkLockSQL = LockStoreSqls.getCheckLockableSql(this.lockTable, sj.toString(), this.dbType);
                ps = conn.prepareStatement(checkLockSQL);
                for (int i = 0; i < lockDOs.size(); ++i) {
                    ps.setString(i + 1, lockDOs.get(i).getRowKey());
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    String xid = rs.getString("xid");
                    if (StringUtils.equals((String)xid, (String)lockDOs.get(0).getXid())) continue;
                    bl = false;
                    break block8;
                }
                bl2 = true;
            }
            catch (SQLException e) {
                try {
                    throw new DataAccessException((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
                    throw throwable;
                }
            }
            IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
            return bl2;
        }
        IOUtil.close((AutoCloseable[])new AutoCloseable[]{rs, ps});
        return bl;
    }

    public void setLockTable(String lockTable) {
        this.lockTable = lockTable;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void setLogStoreDataSource(DataSource logStoreDataSource) {
        this.logStoreDataSource = logStoreDataSource;
    }

    private static /* synthetic */ String lambda$acquireLock$1(LockDO lockDO) {
        return lockDO.getPk();
    }

    private static /* synthetic */ boolean lambda$acquireLock$0(Set dbExistedRowKeys, LockDO lockDO) {
        return !dbExistedRowKeys.contains(lockDO.getRowKey());
    }
}

