/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.collection.LongObjectHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class RpcServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcServerHandler.class);
    private final LongObjectHashMap compressTable = new LongObjectHashMap(16, 0.5f);

    public RpcServerHandler() {
        LOGGER.info("init server handler");
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        LOGGER.info("Server channel read:");
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        ctx.fireUserEventTriggered(evt);
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent event = (IdleStateEvent)evt;
            if (event.state().equals((Object)IdleState.READER_IDLE)) {
                LOGGER.error("READER_IDLE");
                ctx.close();
            } else if (!event.state().equals((Object)IdleState.WRITER_IDLE) && event.state().equals((Object)IdleState.ALL_IDLE)) {
                LOGGER.error("ALL_IDLE");
            }
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        LOGGER.info("channel active for ServerProxyHandler at :[{}]", (Object)ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        LOGGER.info("channel inactive for ServerProxyHandler at :[{}],[{}]", (Object)ctx.channel(), (Object)ctx.channel().remoteAddress());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.close();
        LOGGER.info("channel error:" + cause.getMessage());
    }
}

