/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.collection.LongObjectHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClientHandler
extends ChannelDuplexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcClientHandler.class);
    private final LongObjectHashMap compressTable = new LongObjectHashMap(8192, 0.5f);

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel channel = ctx.channel();
        String request = (String)msg;
        try {
            ctx.writeAndFlush((Object)request, ctx.voidPromise());
            LOGGER.info("client:" + msg);
        }
        catch (Exception e) {
            LOGGER.error("when try flush error", (Throwable)e);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        LOGGER.info("channel active for ClientProxyHandler at :[{}]", (Object)ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        LOGGER.info("channel inactive for ClientProxyHandler at :[{}]", (Object)ctx.channel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.close();
        LOGGER.info("channel error for ClientProxyHandler at :[{}]", (Object)ctx.channel());
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        LOGGER.info("channel write for ClientProxyHandler at :[{}]", msg);
        ctx.write(msg, promise);
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        LOGGER.info("channel flush for ClientProxyHandler at :[{}]", (Object)ctx.channel());
        ctx.flush();
    }
}

