/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.protocol.transaction;

import io.seata.core.model.BranchType;
import io.seata.core.protocol.MergedMessage;
import io.seata.core.protocol.transaction.AbstractTransactionRequestToTC;
import io.seata.core.protocol.transaction.AbstractTransactionResponse;
import io.seata.core.rpc.RpcContext;
import java.nio.ByteBuffer;

public class BranchRegisterRequest
extends AbstractTransactionRequestToTC
implements MergedMessage {
    private static final long serialVersionUID = 1242711598812634704L;
    private String xid;
    private BranchType branchType = BranchType.AT;
    private String resourceId;
    private String lockKey;
    private String applicationData;

    public String getXid() {
        return this.xid;
    }

    public void setXid(String xid) {
        this.xid = xid;
    }

    public BranchType getBranchType() {
        return this.branchType;
    }

    public void setBranchType(BranchType branchType) {
        this.branchType = branchType;
    }

    public String getLockKey() {
        return this.lockKey;
    }

    public void setLockKey(String lockKey) {
        this.lockKey = lockKey;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    @Override
    public short getTypeCode() {
        return 11;
    }

    public String getApplicationData() {
        return this.applicationData;
    }

    public void setApplicationData(String applicationData) {
        this.applicationData = applicationData;
    }

    @Override
    public byte[] encode() {
        byte[] bs;
        int byteLenth = 0;
        byte[] lockKeyBytes = null;
        if (this.lockKey != null && (lockKeyBytes = this.lockKey.getBytes(UTF8)).length > 512) {
            byteLenth += lockKeyBytes.length;
        }
        byte[] applicationDataBytes = null;
        if (this.applicationData != null && (applicationDataBytes = this.applicationData.getBytes(UTF8)).length > 512) {
            byteLenth += applicationDataBytes.length;
        }
        this.byteBuffer = ByteBuffer.allocate(byteLenth + 1024);
        if (this.xid != null) {
            bs = this.xid.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
        this.byteBuffer.put((byte)this.branchType.ordinal());
        if (this.resourceId != null) {
            bs = this.resourceId.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
        if (this.lockKey != null) {
            this.byteBuffer.putInt(lockKeyBytes.length);
            if (lockKeyBytes.length > 0) {
                this.byteBuffer.put(lockKeyBytes);
            }
        } else {
            this.byteBuffer.putInt(0);
        }
        if (this.applicationData != null) {
            this.byteBuffer.putInt(applicationDataBytes.length);
            if (applicationDataBytes.length > 0) {
                this.byteBuffer.put(applicationDataBytes);
            }
        } else {
            this.byteBuffer.putInt(0);
        }
        this.byteBuffer.flip();
        byte[] content = new byte[this.byteBuffer.limit()];
        this.byteBuffer.get(content);
        return content;
    }

    @Override
    public void decode(ByteBuffer byteBuffer) {
        int applicationDataLen;
        int iLen;
        short xidLen = byteBuffer.getShort();
        if (xidLen > 0) {
            byte[] bs = new byte[xidLen];
            byteBuffer.get(bs);
            this.setXid(new String(bs, UTF8));
        }
        this.branchType = BranchType.get(byteBuffer.get());
        short len = byteBuffer.getShort();
        if (len > 0) {
            byte[] bs = new byte[len];
            byteBuffer.get(bs);
            this.setResourceId(new String(bs, UTF8));
        }
        if ((iLen = byteBuffer.getInt()) > 0) {
            byte[] bs = new byte[iLen];
            byteBuffer.get(bs);
            this.setLockKey(new String(bs, UTF8));
        }
        if ((applicationDataLen = byteBuffer.getInt()) > 0) {
            byte[] bs = new byte[applicationDataLen];
            byteBuffer.get(bs);
            this.setApplicationData(new String(bs, UTF8));
        }
    }

    @Override
    public AbstractTransactionResponse handle(RpcContext rpcContext) {
        return this.handler.handle(this, rpcContext);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("xid=");
        result.append(this.xid);
        result.append(",");
        result.append("branchType=");
        result.append((Object)this.branchType);
        result.append(",");
        result.append("resourceId=");
        result.append(this.resourceId);
        result.append(",");
        result.append("lockKey=");
        result.append(this.lockKey);
        return result.toString();
    }
}

