/*
 * Decompiled with CFR 0.152.
 */
package io.seata.common.rpc;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class RpcStatus {
    private static final ConcurrentMap<String, RpcStatus> SERVICE_STATUS_MAP = new ConcurrentHashMap<String, RpcStatus>();
    private final AtomicLong active = new AtomicLong();
    private final LongAdder total = new LongAdder();

    private RpcStatus() {
    }

    public static RpcStatus getStatus(String service) {
        return SERVICE_STATUS_MAP.computeIfAbsent(service, key -> new RpcStatus());
    }

    public static void removeStatus(String service) {
        SERVICE_STATUS_MAP.remove(service);
    }

    public static void beginCount(String service) {
        RpcStatus.getStatus((String)service).active.incrementAndGet();
    }

    public static void endCount(String service) {
        RpcStatus rpcStatus = RpcStatus.getStatus(service);
        rpcStatus.active.decrementAndGet();
        rpcStatus.total.increment();
    }

    public long getActive() {
        return this.active.get();
    }

    public long getTotal() {
        return this.total.longValue();
    }
}

