/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client.http;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.searchbox.action.Action;
import io.searchbox.client.AbstractJestClient;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.client.http.apache.HttpDeleteWithEntity;
import io.searchbox.client.http.apache.HttpGetWithEntity;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestHttpClient
extends AbstractJestClient
implements JestClient {
    static final Logger log = LoggerFactory.getLogger(JestHttpClient.class);
    private CloseableHttpClient httpClient;
    private CloseableHttpAsyncClient asyncClient;
    private Charset entityEncoding = Charset.forName("utf-8");

    public <T extends JestResult> T execute(Action<T> clientRequest) throws IOException {
        String elasticSearchRestUrl = this.getRequestURL(this.getElasticSearchServer(), clientRequest.getURI());
        HttpUriRequest request = this.constructHttpMethod(clientRequest.getRestMethodName(), elasticSearchRestUrl, clientRequest.getData(this.gson));
        log.debug("reqeust method and restUrl - " + clientRequest.getRestMethodName() + " " + elasticSearchRestUrl);
        if (!clientRequest.getHeaders().isEmpty()) {
            for (Map.Entry header : clientRequest.getHeaders().entrySet()) {
                request.addHeader((String)header.getKey(), header.getValue().toString());
            }
        }
        CloseableHttpResponse response = this.httpClient.execute(request);
        if (request.getMethod().equalsIgnoreCase("HEAD") && response.getEntity() == null) {
            if (response.getStatusLine().getStatusCode() == 200) {
                response.setEntity((HttpEntity)new StringEntity("{\"ok\" : true, \"found\" : true}"));
            } else if (response.getStatusLine().getStatusCode() == 404) {
                response.setEntity((HttpEntity)new StringEntity("{\"ok\" : false, \"found\" : false}"));
            }
        }
        return this.deserializeResponse((HttpResponse)response, clientRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends JestResult> void executeAsync(final Action<T> clientRequest, final JestResultHandler<T> resultHandler) throws ExecutionException, InterruptedException, IOException {
        JestHttpClient jestHttpClient = this;
        synchronized (jestHttpClient) {
            if (!this.asyncClient.isRunning()) {
                this.asyncClient.start();
            }
        }
        String elasticSearchRestUrl = this.getRequestURL(this.getElasticSearchServer(), clientRequest.getURI());
        HttpUriRequest request = this.constructHttpMethod(clientRequest.getRestMethodName(), elasticSearchRestUrl, clientRequest.getData(this.gson));
        if (!clientRequest.getHeaders().isEmpty()) {
            for (Map.Entry header : clientRequest.getHeaders().entrySet()) {
                request.addHeader((String)header.getKey(), header.getValue() + "");
            }
        }
        this.asyncClient.execute(request, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse response) {
                try {
                    JestResult jestResult = JestHttpClient.this.deserializeResponse(response, clientRequest);
                    resultHandler.completed((Object)jestResult);
                }
                catch (IOException e) {
                    log.error("Exception occurred while serializing the response. Exception: " + e.getMessage());
                }
            }

            public void failed(Exception ex) {
                resultHandler.failed(ex);
            }

            public void cancelled() {
            }
        });
    }

    public void shutdownClient() {
        super.shutdownClient();
        try {
            this.asyncClient.close();
            this.httpClient.close();
        }
        catch (Exception ex) {
            log.error("Exception occurred while shutting down the asynClient. Exception: " + ex.getMessage());
        }
    }

    protected HttpUriRequest constructHttpMethod(String methodName, String url, Object data) throws UnsupportedEncodingException {
        Object httpUriRequest = null;
        if (methodName.equalsIgnoreCase("POST")) {
            httpUriRequest = new HttpPost(url);
            log.debug("POST method created based on client request");
        } else if (methodName.equalsIgnoreCase("PUT")) {
            httpUriRequest = new HttpPut(url);
            log.debug("PUT method created based on client request");
        } else if (methodName.equalsIgnoreCase("DELETE")) {
            httpUriRequest = new HttpDeleteWithEntity(url);
            log.debug("DELETE method created based on client request");
        } else if (methodName.equalsIgnoreCase("GET")) {
            httpUriRequest = new HttpGetWithEntity(url);
            log.debug("GET method created based on client request");
        } else if (methodName.equalsIgnoreCase("HEAD")) {
            httpUriRequest = new HttpHead(url);
            log.debug("HEAD method created based on client request");
        }
        if (httpUriRequest != null && httpUriRequest instanceof HttpEntityEnclosingRequestBase && data != null) {
            ((HttpEntityEnclosingRequestBase)httpUriRequest).setEntity((HttpEntity)new StringEntity(this.createJsonStringEntity(data), this.entityEncoding));
        }
        return httpUriRequest;
    }

    protected String createJsonStringEntity(Object data) {
        String entity = data instanceof String && this.isJson(data.toString()) ? data.toString() : this.gson.toJson(data);
        log.debug("request body - " + entity);
        return entity;
    }

    private boolean isJson(String data) {
        try {
            JsonElement result = new JsonParser().parse(data);
            return !result.isJsonNull();
        }
        catch (JsonSyntaxException e) {
            String[] bulkRequest = data.split("\n");
            return bulkRequest.length >= 1;
        }
    }

    private <T extends JestResult> T deserializeResponse(HttpResponse response, Action<T> clientRequest) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        return (T)clientRequest.createNewElasticSearchResult(response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity()) : null, statusLine.getStatusCode(), statusLine.getReasonPhrase(), this.gson);
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public CloseableHttpAsyncClient getAsyncClient() {
        return this.asyncClient;
    }

    public void setAsyncClient(CloseableHttpAsyncClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    public Charset getEntityEncoding() {
        return this.entityEncoding;
    }

    public void setEntityEncoding(Charset entityEncoding) {
        this.entityEncoding = entityEncoding;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }
}

