/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client;

import com.google.gson.Gson;
import io.searchbox.client.JestClient;
import io.searchbox.client.config.ClientConfig;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.client.config.discovery.NodeChecker;
import io.searchbox.client.http.JestHttpClient;
import java.net.ProxySelector;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestClientFactory {
    static final Logger log = LoggerFactory.getLogger(JestClientFactory.class);
    private HttpClientConfig httpClientConfig;

    public JestClient getObject() {
        JestHttpClient client = new JestHttpClient();
        if (this.httpClientConfig != null) {
            log.debug("Creating HTTP client based on configuration");
            client.setServers(this.httpClientConfig.getServerList());
            client.setHttpClient(this.createHttpClient());
            Gson gson = this.httpClientConfig.getGson();
            if (gson != null) {
                client.setGson(gson);
            }
            if (this.httpClientConfig.isDiscoveryEnabled()) {
                log.info("Node Discovery Enabled...");
                NodeChecker nodeChecker = new NodeChecker((ClientConfig)this.httpClientConfig, (JestClient)client);
                client.setNodeChecker(nodeChecker);
                nodeChecker.startAsync();
                nodeChecker.awaitRunning();
            } else {
                log.info("Node Discovery Disabled...");
            }
        } else {
            log.debug("There is no configuration to create http client. Going to create simple client with default values");
            client.setHttpClient(HttpClients.createDefault());
            LinkedHashSet<String> servers = new LinkedHashSet<String>();
            servers.add("http://localhost:9200");
            client.setServers(servers);
        }
        client.setAsyncClient(HttpAsyncClients.custom().setRoutePlanner(this.getRoutePlanner()).build());
        return client;
    }

    private CloseableHttpClient createHttpClient() {
        return this.configureHttpClient(HttpClients.custom().setConnectionManager(this.createConnectionManager()).setDefaultRequestConfig(this.createRequestConfig())).setRoutePlanner(this.getRoutePlanner()).build();
    }

    protected HttpClientBuilder configureHttpClient(HttpClientBuilder builder) {
        return builder;
    }

    protected HttpRoutePlanner getRoutePlanner() {
        return new SystemDefaultRoutePlanner(ProxySelector.getDefault());
    }

    protected RequestConfig createRequestConfig() {
        return RequestConfig.custom().setConnectionRequestTimeout(this.httpClientConfig.getConnTimeout()).setSocketTimeout(this.httpClientConfig.getReadTimeout()).build();
    }

    protected HttpClientConnectionManager createConnectionManager() {
        if (this.httpClientConfig.isMultiThreaded()) {
            Integer defaultMaxPerRoute;
            log.debug("Multi-threaded http connection manager created");
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
            Integer maxTotal = this.httpClientConfig.getMaxTotalConnection();
            if (maxTotal != null) {
                cm.setMaxTotal(maxTotal.intValue());
            }
            if ((defaultMaxPerRoute = this.httpClientConfig.getDefaultMaxTotalConnectionPerRoute()) != null) {
                cm.setDefaultMaxPerRoute(defaultMaxPerRoute.intValue());
            }
            Map<HttpRoute, Integer> maxPerRoute = this.httpClientConfig.getMaxTotalConnectionPerRoute();
            for (HttpRoute route : maxPerRoute.keySet()) {
                cm.setMaxPerRoute(route, maxPerRoute.get(route).intValue());
            }
            return cm;
        }
        log.debug("Default http connection is created without multi threaded option");
        return new BasicHttpClientConnectionManager();
    }

    public Class<?> getObjectType() {
        return JestClient.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setHttpClientConfig(HttpClientConfig httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }
}

