/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import io.searchbox.AbstractAction;
import io.searchbox.AbstractMultiTypeActionBuilder;
import io.searchbox.core.search.sort.Sort;
import io.searchbox.params.SearchType;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Search
extends AbstractAction {
    private Search(Builder builder) {
        super(builder);
        String data;
        if (builder.sortList.size() > 0) {
            StringBuilder sorting = new StringBuilder("\"sort\": [");
            sorting.append(StringUtils.join((Collection)builder.sortList, (String)","));
            sorting.append("],");
            data = builder.query.replaceFirst("\\{", "\\{" + sorting.toString());
        } else {
            data = builder.query;
        }
        this.setData(data);
        this.setURI(this.buildURI());
    }

    public String getIndex() {
        return this.indexName;
    }

    public String getType() {
        return this.typeName;
    }

    @Override
    protected String buildURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.buildURI()).append("/_search");
        return sb.toString();
    }

    @Override
    public String getPathToResult() {
        return "hits/hits/_source";
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    public static class Builder
    extends AbstractMultiTypeActionBuilder<Search, Builder> {
        private String query;
        private List<Sort> sortList = new LinkedList<Sort>();

        public Builder(String query) {
            this.query = query;
        }

        public Builder setSearchType(SearchType searchType) {
            return (Builder)this.setParameter("search_type", (Object)searchType);
        }

        public Builder addSort(Sort sort) {
            this.sortList.add(sort);
            return this;
        }

        public Builder addSort(Collection<Sort> sorts) {
            this.sortList.addAll(sorts);
            return this;
        }

        @Override
        public Search build() {
            return new Search(this);
        }
    }
}

