/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.gson.JsonObject;
import io.searchbox.AbstractAction;
import io.searchbox.AbstractDocumentTargetedAction;
import io.searchbox.BulkableAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Index
extends AbstractDocumentTargetedAction
implements BulkableAction {
    static final Logger log = LoggerFactory.getLogger(Index.class);

    private Index(Builder builder) {
        super(builder);
        this.setData(builder.source);
        this.setURI(this.buildURI());
    }

    @Override
    public String getPathToResult() {
        return "ok";
    }

    @Override
    public Boolean isOperationSucceed(JsonObject result) {
        return result.get("ok").getAsBoolean();
    }

    @Override
    public String getRestMethodName() {
        return this.id != null ? "PUT" : "POST";
    }

    @Override
    public String getBulkMethodName() {
        return this.getParameter("op_type") != null && ((String)this.getParameter("op_type")).equalsIgnoreCase("create") ? "create" : "index";
    }

    public static class Builder
    extends AbstractDocumentTargetedAction.Builder<Index, Builder> {
        private final Object source;

        public Builder(Object source) {
            this.source = source;
            this.id(AbstractAction.getIdFromSource(source));
        }

        @Override
        public Index build() {
            return new Index(this);
        }
    }
}

