/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.cluster;

import io.searchbox.AbstractAction;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;

public class NodesInfo
extends AbstractAction {
    private Collection<String> nodes;

    public NodesInfo(Builder builder) {
        super(builder);
        this.nodes = builder.nodes;
        this.setPathToResult("nodes");
        this.setURI(this.buildURI());
    }

    @Override
    protected String buildURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.buildURI()).append("/_cluster/nodes");
        if (this.nodes.size() > 0) {
            sb.append("/").append(StringUtils.join(this.nodes, (String)","));
        }
        return sb.toString();
    }

    @Override
    public String getRestMethodName() {
        return "GET";
    }

    public static class Builder
    extends AbstractAction.Builder<NodesInfo, Builder> {
        private Collection<String> nodes = new LinkedList<String>();

        public Builder addNode(String node) {
            this.nodes.add(node);
            return this;
        }

        public Builder addNode(Collection<? extends String> nodes) {
            this.nodes.addAll(nodes);
            return this;
        }

        public Builder settings(boolean value) {
            return (Builder)this.setParameter("settings", value);
        }

        public Builder os(boolean value) {
            return (Builder)this.setParameter("os", value);
        }

        public Builder process(boolean value) {
            return (Builder)this.setParameter("process", value);
        }

        public Builder jvm(boolean value) {
            return (Builder)this.setParameter("jvm", value);
        }

        public Builder threadPool(boolean value) {
            return (Builder)this.setParameter("thread_pool", value);
        }

        public Builder network(boolean value) {
            return (Builder)this.setParameter("network", value);
        }

        public Builder transport(boolean value) {
            return (Builder)this.setParameter("transport", value);
        }

        public Builder http(boolean value) {
            return (Builder)this.setParameter("http", value);
        }

        public Builder plugin(boolean value) {
            return (Builder)this.setParameter("plugin", value);
        }

        @Override
        public NodesInfo build() {
            return new NodesInfo(this);
        }
    }
}

