/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.sort;

import com.google.gson.Gson;
import java.util.HashMap;

public class Sort {
    private String field = null;
    private Sorting direction = null;
    private Object missing = null;
    private Boolean unmapped = null;

    public Sort(String field) {
        this.field = field;
    }

    public Sort(String field, Sorting direction) {
        this.field = field;
        this.direction = direction;
    }

    public void setMissing(Object m) {
        this.missing = m;
    }

    public void setIgnoreUnmapped() {
        this.unmapped = true;
    }

    public String toString() {
        if (this.direction == null && this.missing == null && this.unmapped == null) {
            return "\"" + this.field + "\"";
        }
        Gson gson = new Gson();
        HashMap<String, Object> obj = new HashMap<String, Object>();
        if (this.direction != null) {
            String dir = "asc";
            if (this.direction == Sorting.DESC) {
                dir = "desc";
            }
            obj.put("order", dir);
        }
        if (this.missing != null) {
            Missing current;
            Object miss = null;
            miss = this.missing instanceof Missing ? ((current = (Missing)((Object)this.missing)) == Missing.LAST ? "_last" : "_first") : this.missing;
            obj.put("missing", miss);
        }
        if (this.unmapped != null) {
            obj.put("ignore_unmapped", this.unmapped);
        }
        String json = gson.toJson(obj);
        return "{ \"" + this.field + "\" : " + json + "}";
    }

    public static enum Missing {
        LAST,
        FIRST;

    }

    public static enum Sorting {
        ASC,
        DESC;

    }
}

