/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.facet;

import io.searchbox.core.search.facet.Facet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TermsStatsFacet
extends Facet {
    public static final String TYPE = "terms_stats";
    private Long missing;
    private List<TermsStats> termsStatsList;

    public TermsStatsFacet(String name, Map termsStatsFacet) {
        this.name = name;
        this.missing = ((Double)termsStatsFacet.get("missing")).longValue();
        this.termsStatsList = new ArrayList<TermsStats>();
        for (Map term : (List)termsStatsFacet.get("terms")) {
            TermsStats termsStats = new TermsStats(term.get("term").toString(), ((Double)term.get("count")).longValue(), ((Double)term.get("total_count")).longValue(), (Double)term.get("total"), (Double)term.get("mean"), (Double)term.get("min"), (Double)term.get("max"));
            this.termsStatsList.add(termsStats);
        }
    }

    public Long getMissing() {
        return this.missing;
    }

    public List<TermsStats> getTermsStatsList() {
        return this.termsStatsList;
    }

    public class TermsStats {
        private String term;
        private Long count;
        private Long totalCount;
        private Double total;
        private Double mean;
        private Double min;
        private Double max;

        public TermsStats(String term, Long count, Long totalCount, Double total, Double mean, Double min, Double max) {
            this.term = term;
            this.count = count;
            this.totalCount = totalCount;
            this.total = total;
            this.mean = mean;
            this.min = min;
            this.max = max;
        }

        public String getTerm() {
            return this.term;
        }

        public Long getCount() {
            return this.count;
        }

        public Long getTotalCount() {
            return this.totalCount;
        }

        public Double getTotal() {
            return this.total;
        }

        public Double getMean() {
            return this.mean;
        }

        public Double getMin() {
            return this.min;
        }

        public Double getMax() {
            return this.max;
        }
    }
}

