/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.facet;

import io.searchbox.core.search.facet.Facet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TermsFacet
extends Facet {
    public static final String TYPE = "terms";
    private Long missing;
    private Long total;
    private Long other;
    private List<Term> terms;

    public TermsFacet(String name, Map termFacet) {
        this.name = name;
        this.missing = ((Double)termFacet.get("missing")).longValue();
        this.total = ((Double)termFacet.get("total")).longValue();
        this.other = ((Double)termFacet.get("other")).longValue();
        this.terms = new ArrayList<Term>();
        for (Map term : (List)termFacet.get(TYPE)) {
            Term entry = new Term(term.get("term").toString(), ((Double)term.get("count")).intValue());
            this.terms.add(entry);
        }
    }

    public Long getMissing() {
        return this.missing;
    }

    public Long getTotal() {
        return this.total;
    }

    public Long getOther() {
        return this.other;
    }

    public List<Term> terms() {
        return this.terms;
    }

    public class Term {
        private String name;
        private Integer count;

        public Term(String name, Integer count) {
            this.name = name;
            this.count = count;
        }

        public String getName() {
            return this.name;
        }

        public Integer getCount() {
            return this.count;
        }
    }
}

