/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.facet;

import io.searchbox.core.search.facet.Facet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RangeFacet
extends Facet {
    public static final String TYPE = "range";
    private List<Range> ranges;

    public RangeFacet(String name, Map rangeFacet) {
        this.name = name;
        this.ranges = new ArrayList<Range>();
        for (Map term : (List)rangeFacet.get("ranges")) {
            Range range = new Range((Double)term.get("from"), (Double)term.get("to"), ((Double)term.get("count")).longValue(), ((Double)term.get("total_count")).longValue(), (Double)term.get("total"), (Double)term.get("min"), (Double)term.get("max"), (Double)term.get("mean"));
            this.ranges.add(range);
        }
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public class Range {
        private Double from = Double.NEGATIVE_INFINITY;
        private Double to = Double.POSITIVE_INFINITY;
        private Long count;
        private Long totalCount;
        private Double total;
        private Double min = Double.POSITIVE_INFINITY;
        private Double max = Double.NEGATIVE_INFINITY;
        private Double mean;

        public Range(Double from, Double to, Long count, Long totalCount, Double total, Double min, Double max, Double mean) {
            this.count = count;
            this.from = from;
            this.to = to;
            this.totalCount = totalCount;
            this.total = total;
            this.min = min;
            this.max = max;
            this.mean = mean;
        }

        public Double getFrom() {
            return this.from;
        }

        public Double getTo() {
            return this.to;
        }

        public Long getCount() {
            return this.count;
        }

        public Long getTotalCount() {
            return this.totalCount;
        }

        public Double getTotal() {
            return this.total;
        }

        public Double getMin() {
            return this.min;
        }

        public Double getMax() {
            return this.max;
        }

        public Double getMean() {
            return this.mean;
        }
    }
}

