/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.facet;

import io.searchbox.core.search.facet.Facet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GeoDistanceFacet
extends Facet {
    public static final String TYPE = "geo_distance";
    private List<Range> ranges;

    public GeoDistanceFacet(String name, Map geoDistanceFacet) {
        this.name = name;
        this.ranges = new ArrayList<Range>();
        for (Map term : (List)geoDistanceFacet.get("ranges")) {
            Range range = new Range((Double)term.get("from"), (Double)term.get("to"), ((Double)term.get("total_count")).longValue(), (Double)term.get("total"), Double.parseDouble(term.get("min").toString()), Double.parseDouble(term.get("max").toString()), (Double)term.get("mean"));
            this.ranges.add(range);
        }
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public class Range {
        private Double from;
        private Double to;
        private Long totalCount;
        private Double total;
        private Double min;
        private Double max;
        private Double mean;

        Range(Double from, Double to, Long totalCount, Double total, Double min, Double max, Double mean) {
            this.from = from;
            this.to = to;
            this.totalCount = totalCount;
            this.total = total;
            this.min = min;
            this.max = max;
            this.mean = mean;
        }

        public Double getFrom() {
            return this.from;
        }

        public Double getTo() {
            return this.to;
        }

        public Long getTotalCount() {
            return this.totalCount;
        }

        public Double getTotal() {
            return this.total;
        }

        public Double getMin() {
            return this.min;
        }

        public Double getMax() {
            return this.max;
        }

        public Double getMean() {
            return this.mean;
        }
    }
}

