/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.facet;

import io.searchbox.core.search.facet.Facet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DateHistogramFacet
extends Facet {
    public static final String TYPE = "date_histogram";
    private List<DateHistogram> dateHistograms;

    public DateHistogramFacet(String name, Map dateHistogramFacet) {
        this.name = name;
        this.dateHistograms = new ArrayList<DateHistogram>();
        for (Map term : (List)dateHistogramFacet.get("entries")) {
            DateHistogram histogram = new DateHistogram(((Double)term.get("time")).longValue(), ((Double)term.get("count")).longValue());
            this.dateHistograms.add(histogram);
        }
    }

    public List<DateHistogram> getDateHistograms() {
        return this.dateHistograms;
    }

    public class DateHistogram {
        private Long time;
        private Long count;

        DateHistogram(Long time, Long count) {
            this.time = time;
            this.count = count;
        }

        public Long getTime() {
            return this.time;
        }

        public Long getCount() {
            return this.count;
        }
    }
}

