/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import io.searchbox.AbstractAction;
import io.searchbox.Action;
import io.searchbox.core.search.sort.Sort;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Search
extends AbstractAction
implements Action {
    static final Logger log = LoggerFactory.getLogger(Search.class);
    protected final LinkedHashSet<String> indexSet = new LinkedHashSet();
    protected final LinkedHashSet<String> typeSet = new LinkedHashSet();

    public Search(String query) {
        this.setData(query);
    }

    public Search(String query, List<Sort> sortList) {
        String sorting = StringUtils.join(sortList, (String)",");
        if (sortList.size() > 0) {
            sorting = "\"sort\": [" + sorting + "],";
            this.setData(query.replaceFirst("\\{", "\\{" + sorting));
        } else {
            this.setData(query);
        }
    }

    protected Search() {
    }

    public void addIndex(String index) {
        if (StringUtils.isNotBlank((String)index)) {
            this.indexSet.add(index);
        }
    }

    public void addType(String type) {
        if (StringUtils.isNotBlank((String)type)) {
            this.typeSet.add(type);
        }
    }

    public boolean removeIndex(String index) {
        return this.indexSet.remove(index);
    }

    public boolean removeType(String type) {
        return this.typeSet.remove(type);
    }

    public void clearAllIndex() {
        this.indexSet.clear();
    }

    public void clearAllType() {
        this.typeSet.clear();
    }

    public void addIndex(Collection<String> index) {
        this.indexSet.addAll(index);
    }

    public void addType(Collection<String> type) {
        this.typeSet.addAll(type);
    }

    public boolean isIndexExist(String index) {
        return this.indexSet.contains(index);
    }

    public boolean isTypeExist(String type) {
        return this.typeSet.contains(type);
    }

    public int indexSize() {
        return this.indexSet.size();
    }

    public int typeSize() {
        return this.typeSet.size();
    }

    @Override
    public String getURI() {
        StringBuilder sb = new StringBuilder();
        String indexQuery = this.createQueryString(this.indexSet);
        String typeQuery = this.createQueryString(this.typeSet);
        if (indexQuery.length() == 0 && typeQuery.length() > 0) {
            sb.append("_all/").append(typeQuery).append("/");
        } else if (indexQuery.length() > 0 && typeQuery.length() > 0) {
            sb.append(indexQuery).append("/").append(typeQuery).append("/");
        } else if (indexQuery.length() > 0 && typeQuery.length() == 0) {
            sb.append(indexQuery).append("/");
        }
        sb.append("_search");
        String queryString = this.buildQueryString();
        if (StringUtils.isNotBlank((String)queryString)) {
            sb.append(queryString);
        }
        log.debug("Created URI for search action is : " + sb.toString());
        return sb.toString();
    }

    protected String createQueryString(LinkedHashSet<String> set) {
        StringBuilder sb = new StringBuilder();
        String tmp = "";
        for (String index : set) {
            sb.append(tmp);
            sb.append(index);
            tmp = ",";
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return "SEARCH";
    }

    @Override
    public String getPathToResult() {
        return "hits/hits/_source";
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    public static String createQueryWithBuilder(String queryBuilderValue) {
        return "{\"query\":" + queryBuilderValue + "}";
    }
}

