/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import io.searchbox.AbstractAction;
import io.searchbox.Action;
import io.searchbox.core.Search;
import java.util.LinkedHashSet;
import java.util.Set;

public class MultiSearch
extends AbstractAction
implements Action {
    private final Set<Search> searchSet = new LinkedHashSet<Search>();

    public void addSearch(Search search) {
        if (search != null) {
            this.searchSet.add(search);
        }
    }

    public boolean isSearchExist(Search search) {
        return this.searchSet.contains(search);
    }

    public void removeSearch(Search search) {
        this.searchSet.remove(search);
    }

    protected Object prepareBulk() {
        StringBuilder sb = new StringBuilder();
        for (Search search : this.searchSet) {
            if (search.indexSet.size() > 0) {
                for (String index : search.indexSet) {
                    sb.append("{\"index\" : \"").append(index).append("\"}\n");
                    sb.append("{\"query\" : ").append(search.getData()).append("}\n");
                }
                continue;
            }
            sb.append("{}\n");
            sb.append("{\"query\" : ").append(search.getData()).append("}\n");
        }
        return sb.toString();
    }

    @Override
    public Object getData() {
        return this.prepareBulk();
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public String getName() {
        return "MULTISEARCH";
    }

    @Override
    public String getURI() {
        return "/_msearch";
    }
}

