/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import io.searchbox.AbstractAction;
import io.searchbox.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreLikeThis
extends AbstractAction
implements Action {
    static final Logger log = LoggerFactory.getLogger(MoreLikeThis.class);

    private MoreLikeThis(Builder builder) {
        this.indexName = builder.index;
        this.typeName = builder.type;
        this.id = builder.id;
        if (builder.query != null) {
            this.setData(builder.query);
            this.setRestMethodName("POST");
        } else {
            this.setRestMethodName("GET");
        }
    }

    @Override
    public String getName() {
        return "MORELIKETHIS";
    }

    @Override
    public String getURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.buildURI(this.indexName, this.typeName, this.id)).append("/").append("_mlt");
        log.debug("Created URI for update action is :" + sb.toString());
        return sb.toString();
    }

    public static class Builder {
        private final String id;
        private String index;
        private String type;
        private Object query;

        public Builder(String id) {
            this.id = id;
        }

        public Builder index(String val) {
            this.index = val;
            return this;
        }

        public Builder type(String val) {
            this.type = val;
            return this;
        }

        public Builder query(Object val) {
            this.query = val;
            return this;
        }

        public MoreLikeThis build() {
            return new MoreLikeThis(this);
        }
    }
}

