/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import io.searchbox.AbstractAction;
import io.searchbox.Action;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Index
extends AbstractAction
implements Action {
    static final Logger log = LoggerFactory.getLogger(Index.class);

    private Index(Builder builder) {
        this.setData(builder.source);
        String id = StringUtils.isNotBlank((String)builder.id) ? builder.id : this.getIdFromSource(builder.source);
        this.prepareIndex(builder.index, builder.type, id);
    }

    private void prepareIndex(String indexName, String typeName, String id) {
        this.indexName = indexName;
        this.typeName = typeName;
        if (id != null) {
            this.setRestMethodName("PUT");
        } else {
            this.setRestMethodName("POST");
        }
        this.id = id;
    }

    @Override
    public String getURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildURI(this.indexName, this.typeName, this.id));
        String queryString = this.buildQueryString();
        if (StringUtils.isNotBlank((String)queryString)) {
            sb.append(queryString);
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return "INDEX";
    }

    @Override
    public String getPathToResult() {
        return "ok";
    }

    public static class Builder {
        private String index = null;
        private String type = null;
        private String id = null;
        private final Object source;

        public Builder(Object source) {
            this.source = source;
        }

        public Builder index(String val) {
            this.index = val;
            return this;
        }

        public Builder type(String val) {
            this.type = val;
            return this;
        }

        public Builder id(String val) {
            this.id = val;
            return this;
        }

        public Index build() {
            return new Index(this);
        }
    }
}

