/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import io.searchbox.AbstractAction;
import io.searchbox.Action;
import org.apache.commons.lang.StringUtils;

public class Get
extends AbstractAction
implements Action {
    private Get(Builder builder) {
        this.indexName = builder.index;
        this.typeName = builder.type;
        this.id = builder.id;
    }

    @Override
    public String getName() {
        return "GET";
    }

    @Override
    public String getURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildURI(this.indexName, this.typeName, this.id));
        String queryString = this.buildQueryString();
        if (StringUtils.isNotBlank((String)queryString)) {
            sb.append(queryString);
        }
        return sb.toString();
    }

    @Override
    public String getRestMethodName() {
        return "GET";
    }

    @Override
    public String getPathToResult() {
        return "_source";
    }

    public static class Builder {
        private String index = null;
        private String type = null;
        private final String id;

        public Builder(String id) {
            this.id = id;
        }

        public Builder index(String val) {
            this.index = val;
            return this;
        }

        public Builder type(String val) {
            this.type = val;
            return this;
        }

        public Get build() {
            return new Get(this);
        }
    }
}

