/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import io.searchbox.AbstractAction;
import io.searchbox.Action;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Delete
extends AbstractAction
implements Action {
    static final Logger log = LoggerFactory.getLogger(Delete.class);

    private Delete(Builder builder) {
        this.indexName = builder.index;
        this.typeName = builder.type;
        this.id = builder.id;
    }

    @Override
    public String getURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buildURI(this.indexName, this.typeName, this.id));
        String queryString = this.buildQueryString();
        if (StringUtils.isNotBlank((String)queryString)) {
            sb.append(queryString);
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return "DELETE";
    }

    @Override
    public String getRestMethodName() {
        return "DELETE";
    }

    @Override
    public String getPathToResult() {
        return "ok";
    }

    public static class Builder {
        private String index;
        private String type;
        private String id;

        public Builder() {
        }

        public Builder(String id) {
            this.id = id;
        }

        public Builder index(String val) {
            this.index = val;
            return this;
        }

        public Builder type(String val) {
            this.type = val;
            return this;
        }

        public Delete build() {
            return new Delete(this);
        }
    }
}

