/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.gson.Gson;
import io.searchbox.AbstractAction;
import io.searchbox.Action;
import io.searchbox.core.Delete;
import io.searchbox.core.Index;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class Bulk
extends AbstractAction
implements Action {
    private final Set<Index> indexSet = new LinkedHashSet<Index>();
    private final Set<Delete> deleteSet = new LinkedHashSet<Delete>();

    public Bulk() {
        this.setURI("_bulk");
    }

    public Bulk(String indexName) {
        this.setURI(this.buildURI(indexName, null, null) + "/_bulk");
    }

    public Bulk(String indexName, String typeName) {
        this.setURI(this.buildURI(indexName, typeName, null) + "/_bulk");
    }

    public void addIndex(Index index) {
        if (index != null) {
            this.indexSet.add(index);
        }
    }

    public void addDelete(Delete delete) {
        if (delete != null) {
            this.deleteSet.add(delete);
        }
    }

    public boolean isIndexExist(Index index) {
        return this.indexSet.contains(index);
    }

    public boolean isDeleteExist(Delete delete) {
        return this.deleteSet.contains(delete);
    }

    public void removeIndex(Index index) {
        this.indexSet.remove(index);
    }

    public void removeDelete(Delete delete) {
        this.deleteSet.remove(delete);
    }

    public void addIndexList(Collection sources) {
        for (Object source : sources) {
            this.addIndex(new Index.Builder(source).build());
        }
    }

    protected Object prepareBulk(Set<AbstractAction> indexSet) {
        StringBuilder sb = new StringBuilder();
        for (AbstractAction action : indexSet) {
            sb.append("{ \"");
            sb.append(action.getName().toLowerCase());
            sb.append("\" : { ");
            boolean putComma = false;
            if (StringUtils.isNotBlank((String)action.getIndexName())) {
                sb.append("\"_index\" : \"");
                sb.append(action.getIndexName());
                sb.append("\"");
                putComma = true;
            }
            if (StringUtils.isNotBlank((String)action.getTypeName())) {
                if (putComma) {
                    sb.append(", ");
                }
                sb.append("\"_type\" : \"");
                sb.append(action.getTypeName());
                sb.append("\"");
                putComma = true;
            }
            if (StringUtils.isNotBlank((String)action.getId())) {
                if (putComma) {
                    sb.append(", ");
                }
                sb.append("\"_id\" : \"").append(action.getId());
                sb.append("\"");
            }
            sb.append("}}\n");
            if (!action.getName().equalsIgnoreCase("index")) continue;
            sb.append(this.getJson(action.getData()));
            sb.append("\n");
        }
        return sb.toString();
    }

    private Object getJson(Object source) {
        if (source instanceof String) {
            return source;
        }
        return new Gson().toJson(source);
    }

    @Override
    public Object getData() {
        LinkedHashSet<AbstractAction> set = new LinkedHashSet<AbstractAction>();
        set.addAll(this.indexSet);
        set.addAll(this.deleteSet);
        return this.prepareBulk(set);
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public String getName() {
        return "BULK";
    }

    @Override
    public String getPathToResult() {
        return "ok";
    }
}

