/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.cluster;

import io.searchbox.AbstractAction;
import io.searchbox.Action;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodesInfo
extends AbstractAction
implements Action {
    static final Logger log = LoggerFactory.getLogger(NodesInfo.class);
    protected final LinkedHashSet<String> nodeSet = new LinkedHashSet();
    private final LinkedHashSet<String> infoSet = new LinkedHashSet();

    public void addNode(String node) {
        if (StringUtils.isNotBlank((String)node)) {
            this.nodeSet.add(node);
        }
    }

    public void addInfo(String info) {
        if (StringUtils.isNotBlank((String)info)) {
            this.infoSet.add(info);
        }
    }

    public boolean removeNode(String node) {
        return this.nodeSet.remove(node);
    }

    public boolean removeInfo(String info) {
        return this.infoSet.remove(info);
    }

    public void clearAllNode() {
        this.nodeSet.clear();
    }

    public void clearAllInfo() {
        this.infoSet.clear();
    }

    public void addNode(Collection<String> node) {
        this.nodeSet.addAll(node);
    }

    public void addInfo(Collection<String> info) {
        this.infoSet.addAll(info);
    }

    public boolean isNodeExist(String node) {
        return this.nodeSet.contains(node);
    }

    public boolean isInfoExist(String info) {
        return this.infoSet.contains(info);
    }

    public int nodeSize() {
        return this.nodeSet.size();
    }

    public int infoSize() {
        return this.infoSet.size();
    }

    @Override
    public String getURI() {
        String info;
        StringBuilder sb = new StringBuilder("_cluster/nodes");
        String nodes = this.concatenateString(this.nodeSet);
        if (nodes.length() > 0) {
            sb.append("/").append(nodes);
        }
        if ((info = this.buildQueryStringForInfo(this.infoSet)).length() > 0) {
            sb.append("?").append(info);
        }
        log.debug("Created URI for Nodes Info action is : " + sb.toString());
        return sb.toString();
    }

    protected String buildQueryStringForInfo(Set<String> infoSet) {
        StringBuilder sb = new StringBuilder();
        String tmp = "";
        for (String info : infoSet) {
            sb.append(tmp);
            sb.append(info).append("=true");
            tmp = "&";
        }
        return sb.toString();
    }

    protected String concatenateString(Set<String> set) {
        StringBuilder sb = new StringBuilder();
        String tmp = "";
        for (String node : set) {
            sb.append(tmp);
            sb.append(node);
            tmp = ",";
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return "NodesInfo";
    }

    @Override
    public String getPathToResult() {
        return "nodes";
    }

    @Override
    public String getRestMethodName() {
        return "GET";
    }
}

