/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client.http;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.searchbox.Action;
import io.searchbox.client.AbstractJestClient;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.client.http.apache.HttpGetWithEntity;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestHttpClient
extends AbstractJestClient
implements JestClient {
    static final Logger log = LoggerFactory.getLogger(JestHttpClient.class);
    private HttpClient httpClient;
    private HttpAsyncClient asyncClient;

    @Override
    public JestResult execute(Action clientRequest) throws IOException {
        String elasticSearchRestUrl = this.getRequestURL(this.getElasticSearchServer(), clientRequest.getURI());
        HttpUriRequest request = this.constructHttpMethod(clientRequest.getRestMethodName(), elasticSearchRestUrl, clientRequest.getData());
        if (!clientRequest.getHeaders().isEmpty()) {
            for (Map.Entry<String, Object> header : clientRequest.getHeaders().entrySet()) {
                request.addHeader(header.getKey(), header.getValue() + "");
            }
        }
        HttpResponse response = this.httpClient.execute(request);
        if (request.getMethod().equalsIgnoreCase("HEAD") && response.getEntity() == null) {
            if (response.getStatusLine().getStatusCode() == 200) {
                response.setEntity((HttpEntity)new StringEntity("{\"ok\" : true, \"found\" : true}"));
            } else if (response.getStatusLine().getStatusCode() == 404) {
                response.setEntity((HttpEntity)new StringEntity("{\"ok\" : false, \"found\" : false}"));
            }
        }
        return this.deserializeResponse(response, clientRequest.getName(), clientRequest.getPathToResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAsync(final Action clientRequest, final JestResultHandler<JestResult> resultHandler) throws ExecutionException, InterruptedException, IOException {
        JestHttpClient jestHttpClient = this;
        synchronized (jestHttpClient) {
            if (this.asyncClient.getStatus() == IOReactorStatus.INACTIVE) {
                this.asyncClient.start();
            }
        }
        String elasticSearchRestUrl = this.getRequestURL(this.getElasticSearchServer(), clientRequest.getURI());
        HttpUriRequest request = this.constructHttpMethod(clientRequest.getRestMethodName(), elasticSearchRestUrl, clientRequest.getData());
        if (!clientRequest.getHeaders().isEmpty()) {
            for (Map.Entry<String, Object> header : clientRequest.getHeaders().entrySet()) {
                request.addHeader(header.getKey(), header.getValue() + "");
            }
        }
        this.asyncClient.execute(request, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse response) {
                try {
                    JestResult jestResult = JestHttpClient.this.deserializeResponse(response, clientRequest.getName(), clientRequest.getPathToResult());
                    resultHandler.completed(jestResult);
                }
                catch (IOException e) {
                    log.error("Exception occurred while serializing the response. Exception: " + e.getMessage());
                }
            }

            public void failed(Exception ex) {
                resultHandler.failed(ex);
            }

            public void cancelled() {
            }
        });
    }

    protected HttpUriRequest constructHttpMethod(String methodName, String url, Object data) throws UnsupportedEncodingException {
        if (methodName.equalsIgnoreCase("POST")) {
            HttpPost httpPost = new HttpPost(url);
            log.debug("POST method created based on client request");
            if (data != null) {
                httpPost.setEntity((HttpEntity)new StringEntity(this.createJsonStringEntity(data), "UTF-8"));
            }
            return httpPost;
        }
        if (methodName.equalsIgnoreCase("PUT")) {
            HttpPut httpPut = new HttpPut(url);
            log.debug("PUT method created based on client request");
            if (data != null) {
                httpPut.setEntity((HttpEntity)new StringEntity(this.createJsonStringEntity(data), "UTF-8"));
            }
            return httpPut;
        }
        if (methodName.equalsIgnoreCase("DELETE")) {
            log.debug("DELETE method created based on client request");
            return new HttpDelete(url);
        }
        if (methodName.equalsIgnoreCase("GET")) {
            log.debug("GET method created based on client request");
            HttpGetWithEntity httpGet = new HttpGetWithEntity(url);
            if (data != null) {
                httpGet.setEntity((HttpEntity)new StringEntity(this.createJsonStringEntity(data), "UTF-8"));
            }
            return httpGet;
        }
        if (methodName.equalsIgnoreCase("HEAD")) {
            log.debug("HEAD method created based on client request");
            return new HttpHead(url);
        }
        return null;
    }

    private String createJsonStringEntity(Object data) {
        if (data instanceof String) {
            if (this.isJson(data.toString())) {
                return data.toString();
            }
            return new Gson().toJson(data);
        }
        return new Gson().toJson(data);
    }

    private boolean isJson(String data) {
        try {
            JsonElement result = new JsonParser().parse(data);
            return !result.equals(JsonNull.INSTANCE);
        }
        catch (JsonSyntaxException e) {
            String[] bulkRequest = data.split("\n");
            return bulkRequest.length >= 1;
        }
    }

    private JestResult deserializeResponse(HttpResponse response, String requestName, String pathToResult) throws IOException {
        return this.createNewElasticSearchResult(EntityUtils.toString((HttpEntity)response.getEntity()), response.getStatusLine(), requestName, pathToResult);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public HttpAsyncClient getAsyncClient() {
        return this.asyncClient;
    }

    public void setAsyncClient(HttpAsyncClient asyncClient) {
        this.asyncClient = asyncClient;
    }
}

