/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client;

import com.google.gson.Gson;
import io.searchbox.annotations.JestId;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestResult {
    static final Logger log = LoggerFactory.getLogger(JestResult.class);
    public static final String ES_METADATA_ID = "es_metadata_id";
    private Map jsonMap;
    private String jsonString;
    private String pathToResult;
    private boolean isSucceeded;

    public String getPathToResult() {
        return this.pathToResult;
    }

    public void setPathToResult(String pathToResult) {
        this.pathToResult = pathToResult;
    }

    public Object getValue(String key) {
        return this.jsonMap.get(key);
    }

    public boolean isSucceeded() {
        return this.isSucceeded;
    }

    public void setSucceeded(boolean succeeded) {
        this.isSucceeded = succeeded;
    }

    public String getJsonString() {
        return this.jsonString;
    }

    public void setJsonString(String jsonString) {
        this.jsonString = jsonString;
    }

    public String getErrorMessage() {
        return (String)this.jsonMap.get("error");
    }

    public Map getJsonMap() {
        return this.jsonMap;
    }

    public void setJsonMap(Map jsonMap) {
        this.jsonMap = jsonMap;
    }

    public <T> T getSourceAsObject(Class<?> clazz) {
        List sourceList = (List)this.extractSource();
        if (sourceList.size() > 0) {
            return this.createSourceObject(sourceList.get(0), clazz);
        }
        return null;
    }

    private <T> T createSourceObject(Object source, Class<?> type) {
        Object obj = null;
        try {
            Field[] fields;
            if (source instanceof Map) {
                Gson gson = new Gson();
                String json = gson.toJson(source, Map.class);
                obj = gson.fromJson(json, type);
            } else {
                obj = type.cast(source);
            }
            for (Field field : fields = type.getDeclaredFields()) {
                if (!field.isAnnotationPresent(JestId.class)) continue;
                try {
                    field.setAccessible(true);
                    Object value = field.get(obj);
                    if (value == null) {
                        field.set(obj, ((Map)source).get(ES_METADATA_ID));
                    }
                }
                catch (IllegalAccessException e) {
                    log.error("Unhandled exception occurred while getting annotated id from source");
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("Unhandled exception occurred while converting source to the object ." + type.getCanonicalName(), (Throwable)e);
        }
        return (T)obj;
    }

    public <T> T getSourceAsObjectList(Class<?> type) {
        ArrayList<T> objectList = new ArrayList<T>();
        if (!this.isSucceeded) {
            return (T)objectList;
        }
        List sourceList = (List)this.extractSource();
        for (Object source : sourceList) {
            T obj = this.createSourceObject(source, type);
            if (obj == null) continue;
            objectList.add(obj);
        }
        return (T)objectList;
    }

    protected Object extractSource() {
        ArrayList sourceList = new ArrayList();
        if (this.jsonMap == null) {
            return sourceList;
        }
        String[] keys = this.getKeys();
        if (keys == null) {
            sourceList.add(this.jsonMap);
            return sourceList;
        }
        String sourceKey = keys[keys.length - 1];
        Object obj = this.jsonMap.get(keys[0]);
        if (keys.length > 1) {
            for (int i = 1; i < keys.length - 1; ++i) {
                obj = ((Map)obj).get(keys[i]);
            }
            if (obj instanceof Map) {
                Map source = (Map)((Map)obj).get(sourceKey);
                if (source != null) {
                    sourceList.add(source);
                }
            } else if (obj instanceof List) {
                for (Object newObj : (List)obj) {
                    Map source;
                    if (!(newObj instanceof Map) || (source = (Map)((Map)newObj).get(sourceKey)) == null) continue;
                    source.put(ES_METADATA_ID, ((Map)newObj).get("_id"));
                    sourceList.add(source);
                }
            }
        } else if (obj != null) {
            sourceList.add(obj);
        }
        return sourceList;
    }

    protected String[] getKeys() {
        return this.pathToResult == null ? null : (this.pathToResult + "").split("/");
    }

    public <T> List<T> getFacets(Class<?> type) {
        ArrayList facets = new ArrayList();
        if (this.jsonMap != null) {
            try {
                Map facetsMap = (Map)this.jsonMap.get("facets");
                for (String facetKey : facetsMap.keySet()) {
                    Map facet = (Map)facetsMap.get(facetKey);
                    if (!facet.get("_type").toString().equalsIgnoreCase(type.getField("TYPE").get(null).toString())) continue;
                    Constructor<?> c = Class.forName(type.getName()).getConstructor(String.class, Map.class);
                    facets.add(c.newInstance(facetKey.toString(), facetsMap.get(facetKey)));
                }
                return facets;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return facets;
    }
}

