/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client;

import com.google.common.collect.Iterators;
import com.google.gson.Gson;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.discovery.NodeChecker;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.http.StatusLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJestClient
implements JestClient {
    static final Logger log = LoggerFactory.getLogger(AbstractJestClient.class);
    public LinkedHashSet<String> servers;
    private Iterator<String> roundRobinIterator;
    private NodeChecker nodeChecker;

    public void setNodeChecker(NodeChecker nodeChecker) {
        this.nodeChecker = nodeChecker;
    }

    public LinkedHashSet<String> getServers() {
        return this.servers;
    }

    @Override
    public void setServers(LinkedHashSet<String> servers) {
        this.servers = servers;
        this.roundRobinIterator = Iterators.cycle(servers);
    }

    @Override
    public void shutdownClient() {
        if (null != this.nodeChecker) {
            this.nodeChecker.stop();
        }
    }

    protected synchronized String getElasticSearchServer() {
        if (this.roundRobinIterator.hasNext()) {
            return this.roundRobinIterator.next();
        }
        throw new RuntimeException("No Server is assigned to client to connect");
    }

    protected JestResult createNewElasticSearchResult(String json, StatusLine statusLine, String requestName, String pathToResult) {
        JestResult result = new JestResult();
        Map jsonMap = this.convertJsonStringToMapObject(json);
        result.setJsonString(json);
        result.setJsonMap(jsonMap);
        result.setPathToResult(pathToResult);
        if (statusLine.getStatusCode() / 100 == 2) {
            if (!this.isOperationSucceed(jsonMap, requestName)) {
                result.setSucceeded(false);
                log.debug("http request was success but operation is failed Status code in 200");
            } else {
                result.setSucceeded(true);
                log.debug("Request and operation succeeded");
            }
        } else {
            result.setSucceeded(false);
            log.debug("Response is failed");
        }
        return result;
    }

    protected boolean isOperationSucceed(Map json, String requestName) {
        try {
            if (requestName.equalsIgnoreCase("INDEX")) {
                return (Boolean)json.get("ok");
            }
            if (requestName.equalsIgnoreCase("DELETE")) {
                return (Boolean)json.get("ok") != false && (Boolean)json.get("found") != false;
            }
            if (requestName.equalsIgnoreCase("UPDATE")) {
                return (Boolean)json.get("ok");
            }
            if (requestName.equalsIgnoreCase("GET")) {
                return (Boolean)json.get("exists");
            }
            if (requestName.equalsIgnoreCase("DELETE_INDEX")) {
                return (Boolean)json.get("ok") != false && (Boolean)json.get("acknowledged") != false;
            }
        }
        catch (Exception e) {
            log.error("Exception occurred during the parsing result. Since http ok going to return isSucceed as a true", (Throwable)e);
        }
        return true;
    }

    protected Map convertJsonStringToMapObject(String jsonTxt) {
        try {
            return (Map)new Gson().fromJson(jsonTxt, Map.class);
        }
        catch (Exception e) {
            log.error("An exception occurred while converting json string to map object");
            return new HashMap();
        }
    }

    protected String getRequestURL(String elasticSearchServer, String uri) {
        String serverUrl = elasticSearchServer.endsWith("/") ? elasticSearchServer.substring(0, elasticSearchServer.length() - 1) : elasticSearchServer;
        StringBuilder sb = new StringBuilder(serverUrl);
        sb.append(uri.startsWith("/") ? uri : "/" + uri);
        return sb.toString();
    }
}

