/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox;

import io.searchbox.Action;
import io.searchbox.annotations.JestId;
import io.searchbox.core.Doc;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAction
implements Action {
    static final Logger log = LoggerFactory.getLogger(AbstractAction.class);
    private Object data;
    private String URI;
    private String restMethodName;
    private boolean isBulkOperation = false;
    protected String indexName;
    protected String typeName;
    protected String id;
    private String pathToResult;
    private final ConcurrentMap<String, Object> parameterMap = new ConcurrentHashMap<String, Object>();
    private final ConcurrentMap<String, Object> headerMap = new ConcurrentHashMap<String, Object>();

    public String getIndexName() {
        return this.indexName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getId() {
        return this.id;
    }

    public void setRestMethodName(String restMethodName) {
        this.restMethodName = restMethodName;
    }

    public void addParameter(String parameter, Object value) {
        this.parameterMap.put(parameter, value);
    }

    public void removeParameter(String parameter) {
        this.parameterMap.remove(parameter);
    }

    public boolean isParameterExist(String parameter) {
        return this.parameterMap.containsKey(parameter);
    }

    public Object getParameter(String parameter) {
        return this.parameterMap.get(parameter);
    }

    public void addHeader(String header, Object value) {
        this.headerMap.put(header, value);
    }

    public void removeHeader(String header) {
        this.headerMap.remove(header);
    }

    public boolean isHeaderExist(String header) {
        return this.headerMap.containsKey(header);
    }

    public Object getHeader(String header) {
        return this.headerMap.get(header);
    }

    @Override
    public Map<String, Object> getHeaders() {
        return this.headerMap;
    }

    public void setURI(String URI) {
        this.URI = URI;
    }

    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public String getURI() {
        if (this.parameterMap.size() > 0) {
            this.URI = this.URI + this.buildQueryString();
        }
        return this.URI;
    }

    @Override
    public String getRestMethodName() {
        return this.restMethodName;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getPathToResult() {
        return this.pathToResult;
    }

    public String getIdFromSource(Object source) {
        Field[] fields;
        if (source == null) {
            return null;
        }
        for (Field field : fields = source.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(JestId.class)) continue;
            try {
                field.setAccessible(true);
                Object name = field.get(source);
                return name == null ? null : name.toString();
            }
            catch (IllegalAccessException e) {
                log.error("Unhandled exception occurred while getting annotated id from source");
            }
        }
        return null;
    }

    protected String buildURI(Doc doc) {
        return this.buildURI(doc.getIndex(), doc.getType(), doc.getId());
    }

    protected String buildURI(String index, String type, String id) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)index)) {
            sb.append(index);
        }
        if (StringUtils.isNotBlank((String)type)) {
            sb.append("/").append(type);
        }
        if (StringUtils.isNotBlank((String)id)) {
            sb.append("/").append(id);
        }
        log.debug("Created uri: " + sb.toString());
        return sb.toString();
    }

    protected String buildQueryString() {
        StringBuilder queryString = new StringBuilder("");
        for (Map.Entry entry : this.parameterMap.entrySet()) {
            if (queryString.length() == 0) {
                queryString.append("?");
            } else {
                queryString.append("&");
            }
            queryString.append(entry.getKey().toString()).append("=").append(entry.getValue().toString());
        }
        return queryString.toString();
    }

    protected boolean isValid(String index, String type, String id) {
        return StringUtils.isNotBlank((String)index) && StringUtils.isNotBlank((String)type) && StringUtils.isNotBlank((String)id);
    }

    protected boolean isValid(Doc doc) {
        return this.isValid(doc.getIndex(), doc.getType(), doc.getId());
    }

    public boolean isBulkOperation() {
        return this.isBulkOperation;
    }

    public void setBulkOperation(boolean bulkOperation) {
        this.isBulkOperation = bulkOperation;
    }

    public void setPathToResult(String pathToResult) {
        this.pathToResult = pathToResult;
    }
}

