/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import io.searchbox.AbstractAction;
import io.searchbox.Action;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validate
extends AbstractAction
implements Action {
    static final Logger log = LoggerFactory.getLogger(Validate.class);

    private Validate(Builder builder) {
        this.indexName = builder.index;
        this.typeName = builder.type;
        this.setURI(this.buildURI(builder.index, builder.type, null));
        this.setData(builder.query);
    }

    @Override
    protected String buildURI(String index, String type, String id) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)index)) {
            sb.append(index);
        }
        if (StringUtils.isNotBlank((String)type)) {
            sb.append("/").append(type);
        }
        if (StringUtils.isNotBlank((String)id)) {
            sb.append("/").append(id);
        }
        sb.append("/").append("_validate/query");
        log.debug("Created URI for validate action is :" + sb.toString());
        return sb.toString();
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public String getName() {
        return "VALIDATE";
    }

    @Override
    public String getPathToResult() {
        return "valid";
    }

    public static class Builder {
        private String index;
        private String type;
        private final Object query;

        public Builder(Object query) {
            this.query = query;
        }

        public Builder index(String val) {
            this.index = val;
            return this;
        }

        public Builder type(String val) {
            this.type = val;
            return this;
        }

        public Validate build() {
            return new Validate(this);
        }
    }
}

