/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import io.searchbox.AbstractAction;
import io.searchbox.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Update
extends AbstractAction
implements Action {
    static final Logger log = LoggerFactory.getLogger(Update.class);
    private Object script;

    private Update(Builder builder) {
        this.indexName = builder.index;
        this.typeName = builder.type;
        this.id = builder.id;
        this.setData(builder.script);
    }

    @Override
    public String getURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.buildURI(this.indexName, this.typeName, this.id)).append("/_update");
        log.debug("Created URI for update action is :" + sb.toString());
        return sb.toString();
    }

    @Override
    public String getName() {
        return "UPDATE";
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public String getPathToResult() {
        return "ok";
    }

    public static class Builder {
        private String index;
        private String type;
        private String id = null;
        private final Object script;

        public Builder(Object script) {
            this.script = script;
        }

        public Builder id(String val) {
            this.id = val;
            return this;
        }

        public Builder index(String val) {
            this.index = val;
            return this;
        }

        public Builder type(String val) {
            this.type = val;
            return this;
        }

        public Update build() {
            return new Update(this);
        }
    }
}

