/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import io.searchbox.AbstractAction;
import io.searchbox.Action;
import io.searchbox.core.Doc;
import java.util.HashSet;
import java.util.List;

public class MultiGet
extends AbstractAction
implements Action {
    protected MultiGet() {
    }

    public MultiGet(List<Doc> docs) {
        this.setURI("_mget");
        this.setBulkOperation(true);
        this.setRestMethodName("POST");
        this.setData(this.prepareMultiGet(docs));
        this.setPathToResult("docs/_source");
    }

    public MultiGet(String type, String[] ids) {
        this.setRestMethodName("POST");
        this.setBulkOperation(true);
        this.setURI("/" + type + "/_mget");
        this.setData(this.prepareMultiGet(ids));
        this.setPathToResult("docs/_source");
    }

    public MultiGet(String[] ids) {
        this.setURI("/_mget");
        this.setData(this.prepareMultiGet(ids));
        this.setRestMethodName("POST");
        this.setBulkOperation(true);
        this.setPathToResult("docs/_source");
    }

    protected Object prepareMultiGet(List<Doc> docs) {
        StringBuilder sb = new StringBuilder("{\"docs\":[");
        for (Doc doc : docs) {
            sb.append("{\"_index\":\"").append(doc.getIndex()).append("\",\"_type\":\"").append(doc.getType()).append("\",\"_id\":\"").append(doc.getId()).append("\"");
            if (doc.getFields().size() > 0) {
                sb.append(",");
                sb.append(this.getFieldsString(doc.getFields()));
            }
            sb.append("}");
            sb.append(",");
        }
        sb.delete(sb.toString().length() - 1, sb.toString().length());
        sb.append("]}");
        return sb.toString();
    }

    private Object getFieldsString(HashSet<String> fields) {
        StringBuilder sb = new StringBuilder("\"fields\":[");
        for (String val : fields) {
            sb.append("\"").append(val).append("\"").append(",");
        }
        sb.delete(sb.toString().length() - 1, sb.toString().length());
        sb.append("]");
        return sb.toString();
    }

    protected Object prepareMultiGet(String[] ids) {
        StringBuilder sb = new StringBuilder("{\"docs\":[").append(this.concatenateArray(ids)).append("]}");
        return sb.toString();
    }

    private String concatenateArray(String[] values) {
        StringBuilder sb = new StringBuilder();
        for (String val : values) {
            sb.append("{\"_id\":\"").append(val).append("\"}").append(",");
        }
        sb.delete(sb.toString().length() - 1, sb.toString().length());
        return sb.toString();
    }

    @Override
    public String getPathToResult() {
        return "docs/_source";
    }
}

