/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import io.searchbox.AbstractAction;
import io.searchbox.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Explain
extends AbstractAction
implements Action {
    static final Logger log = LoggerFactory.getLogger(Explain.class);

    private Explain(Builder builder) {
        this.indexName = builder.index;
        this.typeName = builder.type;
        this.id = builder.id;
        this.setData(builder.query);
    }

    @Override
    public String getRestMethodName() {
        return "GET";
    }

    @Override
    public String getName() {
        return "EXPLAIN";
    }

    @Override
    public String getURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.buildURI(this.indexName, this.typeName, this.id)).append("/_explain");
        log.debug("Created URI for explain action is :" + sb.toString());
        return sb.toString();
    }

    @Override
    protected String buildURI(String index, String type, String id) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.buildURI(index, type, id)).append("/").append("_explain");
        log.debug("Created URI for explain action is :" + sb.toString());
        return sb.toString();
    }

    public static class Builder {
        private String id;
        private String index;
        private String type;
        private final Object query;

        public Builder(Object query) {
            this.query = query;
        }

        public Builder index(String val) {
            this.index = val;
            return this;
        }

        public Builder type(String val) {
            this.type = val;
            return this;
        }

        public Builder id(String val) {
            this.id = val;
            return this;
        }

        public Explain build() {
            return new Explain(this);
        }
    }
}

