/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import io.searchbox.AbstractAction;
import io.searchbox.Action;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteByQuery
extends AbstractAction
implements Action {
    static final Logger log = LoggerFactory.getLogger(DeleteByQuery.class);
    private final LinkedHashSet<String> indexSet = new LinkedHashSet();
    private final LinkedHashSet<String> typeSet = new LinkedHashSet();

    public DeleteByQuery(String query) {
        this.setData(query);
    }

    protected DeleteByQuery() {
    }

    public void addIndex(String index) {
        if (StringUtils.isNotBlank((String)index)) {
            this.indexSet.add(index);
        }
    }

    public void addType(String type) {
        if (StringUtils.isNotBlank((String)type)) {
            this.typeSet.add(type);
        }
    }

    public boolean removeIndex(String index) {
        return this.indexSet.remove(index);
    }

    public boolean removeType(String type) {
        return this.typeSet.remove(type);
    }

    public void clearAllIndex() {
        this.indexSet.clear();
    }

    public void clearAllType() {
        this.typeSet.clear();
    }

    public void addIndex(Collection<String> index) {
        this.indexSet.addAll(index);
    }

    public void addType(Collection<String> type) {
        this.typeSet.addAll(type);
    }

    public boolean isIndexExist(String index) {
        return this.indexSet.contains(index);
    }

    public boolean isTypeExist(String type) {
        return this.typeSet.contains(type);
    }

    public int indexSize() {
        return this.indexSet.size();
    }

    public int typeSize() {
        return this.typeSet.size();
    }

    @Override
    public String getURI() {
        StringBuilder sb = new StringBuilder();
        String indexQuery = this.createQueryString(this.indexSet);
        String typeQuery = this.createQueryString(this.typeSet);
        if (indexQuery.length() == 0) {
            sb.append("_all/");
        } else {
            sb.append(indexQuery).append("/");
            if (typeQuery.length() > 0) {
                sb.append(typeQuery).append("/");
            }
        }
        sb.append("_query");
        log.debug("Created URI for delete by query action is : {}", (Object)sb.toString());
        return sb.toString();
    }

    protected String createQueryString(LinkedHashSet<String> set) {
        StringBuilder sb = new StringBuilder();
        String tmp = "";
        for (String index : set) {
            sb.append(tmp);
            sb.append(index);
            tmp = ",";
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return "DELETEBYQUERY";
    }

    @Override
    public String getPathToResult() {
        return "ok";
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }
}

